<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use kanazaca\CounterCache\CounterCache;
use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Auth\Authenticatable as AuthenticableTrait;
use Kyslik\ColumnSortable\Sortable;

class User extends Model implements Authenticatable
{
    use CounterCache, Notifiable, AuthenticableTrait, Sortable;
    
    // you can have more than one counter
    public $counterCacheOptions = [
        'UserType' => ['field' => 'user_count', 'foreignKey' => 'user_type_id']
    ];

    public $sortable = ['id', 'firstname'];

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'users';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
                  'firstname',
                  'lastname',
                  'email',
                  'password',
                  'country_code',
                  'mobile',
                  'is_mobile_verified',
                  'user_type_id',
                  'status',
                  'otp',
                  'document',
                  'dob',
                  'profile_pic',
                  'short_bio',
                  'facebook_profile',
                  'linkedin_profile',
                  'address',
                  'city',
                  'emirates_id_expiration_date',
                  'passport'
              ];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [];
    
    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [];
    
    /**
     * Get the userType for this model.
     */
    public function userType()
    {
        return $this->belongsTo('App\Models\UserType','user_type_id');
    }


    /**
     * Get created_at in array format
     *
     * @param  string  $value
     * @return array
     */
    public function getCreatedAtAttribute($value)
    {
        return date('j/n/Y g:i A', strtotime($value));
    }

    /**
     * Get updated_at in array format
     *
     * @param  string  $value
     * @return array
     */
    public function getUpdatedAtAttribute($value)
    {
        return date('j/n/Y g:i A', strtotime($value));
    }

}
