<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

class Transaction extends Model
{
  use Sortable;

  public $sortable = ['id','amount'];

	/**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'transactions';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
                  'model_id',
                  'amount',
                  'payment_method_code',
                  'payment_status_id',
                  'reference_id',
                  'user_id',
                  'parent_id',
                  'custom1',
                  'custom2',
                  'custom3'
              ];
    
    /**
     * Get the user for this model.
     */
    public function user()
    {
        return $this->belongsTo('App\Models\User','user_id');
    }

    /**
     * Get the payment status for this model.
     */
    public function PaymentStatus()
    {
        return $this->belongsTo('App\Models\PaymentStatus','payment_status_id');
    }

}   
