<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TenancyContract extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'tenancy_contracts';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
                  'id',
                  'created_at',
                  'updated_at',
                  'bid_id',
                  'landlord_id',
                  'tenant_id',
                  'contract_date',
                  'contract_month',
                  'contract_year',
                  'contract_number',
                  'property_usage',
                  'owner_name',
                  'landlord_name',
                  'tenant_name',
                  'landlord_email',
                  'tenant_email',
                  'tenant_phone',
                  'landlord_phone',
                  'building_name',
                  'building_location',
                  'property_size',
                  'property_type',
                  'property_number',
                  'premises_number',
                  'plot_number',
                  'contract_period_from',
                  'contract_period_to',
                  'annual_rent',
                  'contract_value',
                  'security_deposit',
                  'payment_mode',
                  'tenant_signature_date'
              ];

    /**
     * Get the Bid for this model.
     */
    public function bid()
    {
        return $this->hasOne('App\Models\Bidding','bid_id');
    }

    /**
     * Get the Landlord for this model.
     */
    public function landlord()
    {
        return $this->belongsTo('App\Models\User','landlord_id');
    }

    /**
     * Get the Tenant for this model.
     */
    public function tenant()
    {
        return $this->belongsTo('App\Models\User','tenant_id');
    }
    
    /**
     * Get created_at in array format
     *
     * @param  string  $value
     * @return array
     */
    public function getCreatedAtAttribute($value)
    {
        return date('n/j/Y H:i A', strtotime($value));
    }

    /**
     * Get updated_at in array format
     *
     * @param  string  $value
     * @return array
     */
    public function getUpdatedAtAttribute($value)
    {
        return date('n/j/Y H:i A', strtotime($value));
    }
}
