<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

class Support extends Model
{
    use Sortable;

    public $sortable = ['id'];

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'supports';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Get the user for this model.
     */
    public function user()
    {
        return $this->belongsTo('App\Models\User','user_id');
    }

    /**
     * Get the property for this model.
     */
    public function property()
    {
        return $this->belongsTo('App\Models\Property','property_id');
    }

    /**
     * Get the bid for this model.
     */
    public function bid()
    {
        return $this->belongsTo('App\Models\Bidding','bid_id');
    }

}
