<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SmsReport extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'sms_reports';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
                  'user_id',
                  'recipient',
                  'message',
                  'message_id',
              ];

    /**
     * Get the User for this model.
     */
    public function user()
    {
        return $this->belongsTo('App\Models\User','user_id');
    }
}
