<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use kanazaca\CounterCache\CounterCache;
use Kyslik\ColumnSortable\Sortable;

class Property extends Model
{
    use CounterCache, Sortable;

    // you can have more than one counter
    public $counterCacheOptions = [
        'PropertyStatus' => ['field' => 'property_count', 'foreignKey' => 'property_status_id']
    ];

    public $sortable = ['id', 'name', 'property_status_id', 'yearly_price', 'monthly_rent', 'available_from', 'bid_closure_date','bid_selected'];

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'properties';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
                  'name',
                  'address',
                  'unit',
                  'area',
                  'description',
                  'latitude',
                  'longitude',
                  'monthly_rent',
                  'security_deposit',
                  'total_price',
                  'other_policies',
                  'available_from',
                  'emirate_id',
                  'property_type_id',
                  'vieweing_option_id',
                  'bedroom_size_id',
                  'washroom_size_id',
                  'landlord_id',
                  'bid_count',
                  'property_status_id',
                  'view_count',
                  'property_term_id',
                  'bid_closure_date',
                  'number_of_payments_id',
                  'yearly_price',
                  'title_deed',
                  'property_term_period'
              ];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [];
    
    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [];
    
    /**
     * Get the emirate for this model.
     */
    public function emirate()
    {
        return $this->belongsTo('App\Models\Emirate','emirate_id');
    }

    /**
     * Get the propertyType for this model.
     */
    public function propertyType()
    {
        return $this->belongsTo('App\Models\PropertyType','property_type_id');
    }

    /**
     * Get the vieweingOption for this model.
     */
    public function vieweingOption()
    {
        return $this->belongsTo('App\Models\VieweingOption','vieweing_option_id');
    }

    /**
     * Get the bedroomSize for this model.
     */
    public function bedroomSize()
    {
        return $this->belongsTo('App\Models\BedroomSize','bedroom_size_id');
    }

    /**
     * Get the washroomSize for this model.
     */
    public function washroomSize()
    {
        return $this->belongsTo('App\Models\WashroomSize','washroom_size_id');
    }

    /**
     * Get the lanlord for this model.
     */
    public function landlord()
    {
        return $this->belongsTo('App\Models\User','landlord_id');
    }

    /**
     * Get the propertyStatus for this model.
     */
    public function propertyStatus()
    {
        return $this->belongsTo('App\Models\PropertyStatus','property_status_id');
    }
    /**
     * Get the noofpayments for this model.
     */
    public function noOfPayments()
    {
        return $this->belongsTo('App\Models\NumberofPayment','number_of_payments_id');
    }

    /**
     * Get the User for this model.
     */
    public function user()
    {
        return $this->belongsTo('App\Models\User','landlord_id');
    }

    /**
     * Get media of the property
     */
    public function media()
    {
        return $this->hasMany('App\Models\Media', 'parent_id')->where('model_id',env('PROPERTY',''));
    }

    /**
     * Get amaneities of the property
     */
    public function amenityProperty()
    {
        return $this->hasMany('App\Models\AmenityProperty', 'property_id');
    }
	
	/**
     * Get terms and conditions of the property
     */
    public function propertyTerm()
    {
        return $this->hasMany('App\Models\PropertyTerm', 'property_id');
    }

    /**
     * Get amaneities of the property
     */
    public function bidding()
    {
        return $this->hasMany('App\Models\Bidding', 'property_id');
    }

    /**
     * Get created_at in array format
     *
     * @param  string  $value
     * @return array
     */
    public function getCreatedAtAttribute($value)
    {
        //return date('j/n/Y g:i A', strtotime($value));
        return $value;
    }

    /**
     * Get updated_at in array format
     *
     * @param  string  $value
     * @return array
     */
    public function getUpdatedAtAttribute($value)
    {
        //return date('j/n/Y g:i A', strtotime($value));
        return $value;
    }

}
