<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Note extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'notes';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
                  'bid_id',
                  'landlord_id',
                  'visibility_id',
                  'content'
              ];
    
    /**
     * Get the bid for this model.
     */
    public function bid()
    {
        return $this->belongsTo('App\Models\Bidding','bid_id');
    }

    /**
     * Get the landlord for this model.
     */
    public function landlord()
    {
        return $this->belongsTo('App\Models\User','landlord_id');
    }

    /**
     * Get the landlordNoteVisibilityStatus for this model.
     */
    public function landlordNoteVisibilityStatus()
    {
        return $this->belongsTo('App\Models\LandlordNoteVisibilityStatus','visibility_id');
    }    
}
