<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Contract extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'contracts';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
                  'property_id',
                  'landlord_id',
                  'bid_id',
                  'tenant_id',
                  'path'
              ];

    /**
     * Get the Property for this model.
     */
    public function property()
    {
        return $this->belongsTo('App\Models\Property','property_id');
    }

    /**
     * Get the Bid for this model.
     */
    public function bid()
    {
        return $this->belongsTo('App\Models\Bidding','bid_id');
    }

    /**
     * Get the Landlord for this model.
     */
    public function landlord()
    {
        return $this->belongsTo('App\Models\User','landlord_id');
    }

    /**
     * Get the Tenant for this model.
     */
    public function tenant()
    {
        return $this->belongsTo('App\Models\User','tenant_id');
    }

}
