<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use kanazaca\CounterCache\CounterCache;
use Kyslik\ColumnSortable\Sortable;

class Bidding extends Model
{
    use CounterCache, Sortable;

    // you can have more than one counter
    public $counterCacheOptions = [
        'Property' => ['field' => 'bid_count', 'foreignKey' => 'property_id']
    ];

    public $sortable = ['id','propose_rent','move_in_date'];

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'biddings';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
                  'property_id',
                  'tenant_id',
                  'propose_rent',
                  'move_in_date',
                  'tenant_note',
                  'employment_status_id',
                  'landlord_note',
                  'landlord_note_visibility_status_id',
                  'bid_status_id',
                  'bid_priority_id',
                  'bid_selected',
                  'updated_at',
                  'bid_selection_time'
              ];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [];
    
    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [];
    
    /**
     * Get the property for this model.
     */
    public function property()
    {
        return $this->belongsTo('App\Models\Property','property_id');
    }

    /**
     * Get the tenant for this model.
     */
    public function tenant()
    {
        return $this->belongsTo('App\Models\User','tenant_id');
    }

    /**
     * Get the employmentStatus for this model.
     */
    public function employmentStatus()
    {
        return $this->belongsTo('App\Models\EmploymentStatus','employment_status_id');
    }

    /**
     * Get the landlordNoteVisibilityStatus for this model.
     */
    public function landlordNoteVisibilityStatus()
    {
        return $this->belongsTo('App\Models\LandlordNoteVisibilityStatus','landlord_note_visibility_status_id');
    }

    /**
     * Get the bidStatus for this model.
     */
    public function bidStatus()
    {
        return $this->belongsTo('App\Models\BidStatus','bid_status_id');
    }

    /**
     * Get the bidPriority for this model.
     */
    public function bidPriority()
    {
        return $this->belongsTo('App\Models\BidPriority','bid_priority_id');
    }

    /**
     * Get the contract for this model.
     */
    /*public function contract()
    {
        return $this->belongsTo('App\Models\Contract','contract_id');
    }*/

    /**
     * Get the Tenancy contract for this model.
     */
    public function tenancyContract()
    {
        return $this->belongsTo('App\Models\TenancyContract','contract_id');
    }


    /**
     * Get the transaction for this model.
     */
    public function transaction()
    {
        return $this->hasMany('App\Models\Transaction','parent_id')->where('model_id', env('BIDDING'));
    }


    /**
     * Set the move_in_date.
     *
     * @param  string  $value
     * @return void
     */
    public function setMoveInDateAttribute($value)
    {
        $this->attributes['move_in_date'] = !empty($value) ? date($this->getDateFormat(), strtotime($value)) : null;
    }

    /**
     * Get move_in_date in array format
     *
     * @param  string  $value
     * @return array
     */
    public function getMoveInDateAttribute($value)
    {
        //return date('j/n/Y', strtotime($value));
        return $value;
    }

    /**
     * Get landlord notes of the property
     */
    public function note()
    {
        return $this->hasMany('App\Models\Note', 'bid_id');
    }

}
