<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AppCode extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'app_codes';

    /**
     * Scope a query to only include emirate
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeEmirate($query)
    {
        return $query->where('app_code_category_id', '=', 1);
    }

    /**
     * Scope a query to only include property_type
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopePropertyType($query)
    {
        return $query->where('app_code_category_id', '=', 2);
    }

    /**
     * Scope a query to only include vieweing options
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeVieweingOption($query)
    {
        return $query->where('app_code_category_id', '=', 3);
    }

    /**
     * Scope a query to only include bed room sizes
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeBedroomSizes($query)
    {
        return $query->where('app_code_category_id', '=', 4);
    }

    /**
     * Scope a query to only include wash room sizes
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeWashroomSizes($query)
    {
        return $query->where('app_code_category_id', '=', 5);
    }

    /**
     * Scope a query to only include employment status
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeEmploymentStatus($query)
    {
        return $query->where('app_code_category_id', '=', 6);
    }

    /**
     * Scope a query to only include bid status
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeBidStatus($query)
    {
        return $query->where('app_code_category_id', '=', 9);
    }

    /**
     * Scope a query to only include number of payments
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeNumberOfPayments($query)
    {
        return $query->where('app_code_category_id', '=', 10);
    }

    /**
     * Scope a query to only include number of payments
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeTermsCondition($query)
    {
        return $query->where('app_code_category_id', '=', 11);
    }	
}
