<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use kanazaca\CounterCache\CounterCache;

class AmenityProperty extends Model
{
    use CounterCache;

    // you can have more than one counter
    public $counterCacheOptions = [
        'Amenity' => ['field' => 'property_count', 'foreignKey' => 'amenity_id']
    ];

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'amenity_property';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
                  'amenity_id',
                  'property_id',
              ];

    /**
     * Get the amenity for this model.
     */
    public function amenity()
    {
        return $this->belongsTo('App\Models\Amenity','amenity_id');
    }

    /**
     * Get the property for this model.
     */
    public function property()
    {
        return $this->belongsTo('App\Models\Property','property_id');
    }

    /**
     * Get created_at in array format
     *
     * @param  string  $value
     * @return array
     */
    public function getCreatedAtAttribute($value)
    {
        return date('j/n/Y g:i A', strtotime($value));
    }

    /**
     * Get updated_at in array format
     *
     * @param  string  $value
     * @return array
     */
    public function getUpdatedAtAttribute($value)
    {
        return date('j/n/Y g:i A', strtotime($value));
    }
}

