<?php

namespace App\Http\Middleware;
use Auth;
use Closure;
use Session;
class RoleMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next, $role)
    {
        $url = 'http://' . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];

        $user_type_id = (Auth::user()) ? Auth::user()->user_type_id : '';        
        if($role != $user_type_id){
            Session::flash('Error','Unauthorised access !'); 
            if (strpos($url,'admin') !== false) {
                return redirect('/administrator');
            }
            else{
                return redirect('/');
            }
        }
        else{
            return $next($request);
        }
    }
}
