<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\UserType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use DB;
use Session;
use File;
use Redirect;
use Mail;
use App\Models\SmsReport;
use App\Models\Property;
use App\Models\Bidding;
use App\Models\Support;
use App\Component\Bidding\Biddings as Biddings;
use Auth;
use Excel;
class UsersController extends MailsController
{
    /**
     * Registering user
     *
     * @param  Request  $request
     * @return Response
     */
        public function signup(Request $request){
            //Matching Password & confirm- password
            if($request->input('password') == $request->input('confirmpassword')){
                //Validating data entered by user
                $request->validate(['firstname'=>'required',
                    'lastname'=>'required',
                    'email'=>'required|email|unique:users,email',
                    'password'=>'required|min:8|regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d).+$/',
                    // 'country_code'=>'required',
                    'mobile'=>'required|unique:users,mobile',
                    'user_type'=>'required',
                    // 'document' => 'required_if:user_type,3|mimes:jpeg,pdf,jpg|max:1024',
                ]);

                //Creating object of User Model                
                $user = new User;

                //Setting data array
                $data['created_at'] = date("Y-m-d H:i:s");
                $data['updated_at'] = date("Y-m-d H:i:s");
                $user->firstname = $firstname = $data['firstname'] = $request->input('firstname');
                $user->lastname = $lastname = $data['lastname'] = $request->input('lastname');
                $email = $user->email = $data['email'] = $request->input('email');
                $password = $request->input('password');
                $user->password = $data['password'] = Hash::make($password); //Encrypting password
                $country_code = $user->country_code = $data['country_code'] = $request->input('country_code');
                $mobile_number = $user->mobile = $data['mobile'] = $request->input('mobile');
                $user->user_type_id = $user_type_id = $data['user_type_id'] = $request->input('user_type');
                $user->is_mobile_verified = $data['is_mobile_verified'] = 0;
                $user->status = $data['status'] = 1;
                $otp = rand(100000, 999999);
                $user->otp = $data['otp'] = $otp;
                $user->document = $data['document'] = '';

                if($user_type_id ==3){
                    //Uploading passport scan copy of tenant
                    $imageName = $request->input('mobile').'_'.time().'.'.$request->document->getClientOriginalExtension();
                }

                $user->save(); // This will also auto-update the user_count in user_types table
                $user_id = $user->id;
                
                if($user_type_id ==3){
                    $path = public_path('media/tenant/'.$user_id);
                    File::makeDirectory($path);
                    $request->document->move($path, $imageName);

                    $document_path = 'media/tenant/'.$user_id.'/'.$imageName;

                    DB::table('users')
                        ->where('id', $user_id)
                        ->update(['document' => $document_path]);
                }

                /* Sending OTP for verifying mobile number */
                $msg_body = "Please use ".$otp." as OTP for verifying your mobile number";
                $recipients = $country_code.$mobile_number;
                $response = Controller::SendSMS(env('SMS_API_URL'), env('SMS_USERNAME'), env('SMS_PASSWORD'), $msg_body, env('SMS_MSG_ENCODING'), env('SMS_COUNTRY_CODE'), env('SMS_AREA_CODE'), $recipients, env('SMS_HEADER'));
                
                $response_array = explode('=', $response);
                
                $sms_data['user_id'] = $user_id;
                $sms_data['recipient'] = $recipients;
                $sms_data['message'] = $msg_body;
                $sms_data['message_id'] = '';
                $error = substr($response_array[1],0,1);
                # if there is not error then save SMS to sms_reports table
                if($error == 0){                    
                    $sms_data['message_id'] = preg_replace('/(<BR>)+$/', '', $response_array[2]);
                    #Creating object for sms_report model
                    $sms_report = new SmsReport;
                    $sms_report->fill($sms_data);
                    $sms_report->save($sms_data);

                }

                /* Send OTP via Email*/
                 $mail_result = $this->send_otp($firstname.' '.$lastname, $email, $otp);

                $user_detail = User::where(['id'=>$user_id])->first();
                Auth::login($user_detail);
                
                //flash message
                Session::flash('Success', 'You have been registered successfully, OTP has been sent to your contact number & registered email. Please enter the ORP & verify your mobile number'); 
                //Session::flash('alert-class', 'alert-success');

                return redirect('/users/verify');
            }
            else{
                Session::flash('Error', 'Password & Confirm-password did not match !'); 
                Session::flash('alert-class', 'alert-danger');  
            }
            //redirect
            return redirect('/');
        }

    /**
     * User Login Section
     *
     * @param  Request  $request
     * @return Response
     */
        public function login(Request $request){
            $email = $request->input('emailaddress');
            $password = $request->input('password');

            if (Auth::attempt(['email' => $email, 'password' => $password, 'status' => 1])) {
                if(Auth::user()->user_type_id == env('USER_TYPE_ADMIN')){
                    Session::flash('Error','You have entered admin credentials, you can login from this page');
                    Auth::logout();
                    return redirect('administrator');
                }
                // Authentication passed...
                if(Auth::user()->is_mobile_verified==1){
                    $user_login_detail = DB::table('user_logins')->where('user_id',Auth::user()->id)->first();
                    if(!empty($user_login_detail)){
                        DB::table('user_logins')
                                    ->where('user_id',Auth::user()->id)
                                    ->update(['login_time' => date("Y-m-d H:i:s"), 'updated_at' => date("Y-m-d H:i:s")]);
                    }
                    else{
                        $data['user_id'] = Auth::user()->id;
                        $data['login_time'] = date("Y-m-d H:i:s");

                        //inserting in table
                        DB::table('user_logins')->insert($data);
                    }
                }
                else{
                    $otp = Auth::user()->otp;
                    /* Sending OTP for verifying mobile number */
                    $msg_body = "Please use ".$otp." as OTP for verifying your mobile number";
                    $recipients = Auth::user()->country_code.Auth::user()->mobile;
                    $response = Controller::SendSMS(env('SMS_API_URL'), env('SMS_USERNAME'), env('SMS_PASSWORD'), $msg_body, env('SMS_MSG_ENCODING'), env('SMS_COUNTRY_CODE'), env('SMS_AREA_CODE'), $recipients, env('SMS_HEADER'));
                    
                    $response_array = explode('=', $response);                        
                    $sms_data['user_id'] = Auth::user()->id;
                    $sms_data['recipient'] = $recipients;
                    $sms_data['message'] = $msg_body;
                    $sms_data['message_id'] = '';
                    $error = substr($response_array[1],0,1);
                    # if there is not error then save SMS to sms_reports table
                    if($error == 0){                    
                        $sms_data['message_id'] = preg_replace('/(<BR>)+$/', '', $response_array[2]);
                        #Creating object for sms_report model
                        $sms_report = new SmsReport;
                        $sms_report->fill($sms_data);
                        $sms_report->save($sms_data);
                    }
                    //redirect
                    Session::flash('Success', 'Please verify your mobile number'); 
                    return redirect('/users/verify');
                }
                if(Auth::user()->user_type_id == env('USER_TYPE_LANDLORD'))
                    return redirect('/properties/manage');
                else
                    return redirect()->back();
            }
            else{
                Session::flash('Modal_Error', 'Invalid Credentials !');
                return redirect()->back()->with('error_code', 2);
            }
        }

    /**
     * User Logout Section
     *
     * @param  Request  $request
     * @return Response
     */
        public function logout(){
            if(empty(Auth::user())){
                Session::flush();
                Auth::logout();
                Session::flash('Success', 'You have logged out successfully'); 
                return redirect('/');
            }
            else{
                //Updating Logout time in user_logins table
                DB::table('user_logins')
                    ->where('user_id',Auth::user()->id)
                    ->update(['logout_time' => date("Y-m-d H:i:s"), 'updated_at' => date("Y-m-d H:i:s")]);
                Session::flush();
                Auth::logout();
                Session::flash('Success', 'You have logged out successfully'); 
                return redirect('/');
            }
        }

    /**
     * Forget Password Section
     *
     * @param  Request  $request
     * @return Response
     */
        public function forgetPassword(Request $request){
            $email = $request->input('forgetemailaddress');

            $user_details = DB::table('users')
                                        ->select('firstname','lastname')
                                        ->where('email', $email)
                                        ->first();
            if($user_details){
                $firstname = $user_details->firstname;
                $lastname = $user_details->lastname;                                        

                $chars = "abcdefghijkmnpqrstuvwxyzABCDEFGHIJKLMNPQRSTUVWXYZ23456789!@#$%";
                $password = substr(str_shuffle($chars), 0, 8); //Generate new password
                $new_password = Hash::make($password); //Encrypting password
                if(DB::table('users')
                            ->where('email', $email)
                            ->update(['password' => $new_password, 'updated_at' => date("Y-m-d H:i:s")])){

                    $mail_result = $this->html_email($firstname, $lastname, $email, $password);
                    
                    //flash message
                    Session::flash('Forget_Success', 'Password has been sent to you email');
                    return redirect()->back()->with('error_code', 3);
                }
                else{
                    Session::flash('Forget_Error', 'Something went wrong !');
                    return redirect()->back()->with('error_code', 3);
                }
            }
            else{
                Session::flash('Forget_Error', 'Email id does not exist !');
                return redirect()->back()->with('error_code', 3);
            }         
        }

    /**
     * Verify OTP Section
     *
     * @param  Request  $request
     * @return Response
     */
        public function verify(){
            if($_SERVER['REQUEST_METHOD']=='POST'){
                $otp = $_POST['otp'];
                $user_id = $_POST['user_id'];
                $sent_otp = Auth::user()->otp;
                $session_user_id = Auth::user()->id;

                if(($otp==$sent_otp) && ($user_id==$session_user_id)){
                    User::where('id', $user_id)->update(['is_mobile_verified' => 1]);
                    
                    if(Session::has('profile_updated')){
                        session()->forget('profile_updated');
                        Session::flash('Success', 'Your profile was successfully updated.'); 
                        return Redirect:: route('profile',[Auth::user()->id]);
                    }
                    //Removing Session variable
                    Session::flush();
                    Session::flash('Success', 'You have registered successfully. You need to Sign In for further activities.'); 
                    return redirect('/');
                }
                else{
                    Session::forget('user_id');
                    Session::flash('Error', 'Invalid OTP !'); 
                    return redirect('/users/verify');
                }
            }
            else{
                return view('verify');  
            }
        }

    /**
     * Generate OTP Section
     *
     * @param  Request  $request
     * @return Response
     */
        public function generateOTP(){
            $otp = rand(100000, 999999);
            $user_id = Auth::user()->id;
            $firstname = Auth::user()->firstname;
            $lastname = Auth::user()->lastname;
            $email = Auth::user()->email;

            User::where('id', $user_id)->update(['otp' => $otp]);
            Auth::user()->otp = $otp;

            /* Sending OTP for verifying mobile number */
            $msg_body = "Please use ".$otp." as OTP for verifying your mobile number";
            $recipients = Auth::user()->country_code.Auth::user()->mobile;
            $response = Controller::SendSMS(env('SMS_API_URL'), env('SMS_USERNAME'), env('SMS_PASSWORD'), $msg_body, env('SMS_MSG_ENCODING'), env('SMS_COUNTRY_CODE'), env('SMS_AREA_CODE'), $recipients, env('SMS_HEADER'));
            
            $response_array = explode('=', $response);                        
            $sms_data['user_id'] = $user_id;
            $sms_data['recipient'] = $recipients;
            $sms_data['message'] = $msg_body;
            $sms_data['message_id'] = '';
            $error = substr($response_array[1],0,1);
            # if there is not error then save SMS to sms_reports table
            if($error == 0){                    
                $sms_data['message_id'] = preg_replace('/(<BR>)+$/', '', $response_array[2]);
                #Creating object for sms_report model
                $sms_report = new SmsReport;
                $sms_report->fill($sms_data);
                $sms_report->save($sms_data);
            }

            /* Send OTP via Email*/
                $mail_result = $this->send_otp($firstname.' '.$lastname, $email, $otp);

            //redirect
            Session::flash('Success', 'OTP has been sent to your contact number & registered email. Please enter the OTP & verify your mobile number'); 
            return redirect('/users/verify');
        }

    /**
     * Get Change Password View
     *
     * @param  $id
     * @return Response
     */ 
    public function changePasswordIndex()
    {
        $id = Auth::user()->id;
        $userInfo = User::where('id',$id)->get()->toArray();
        return view('users.changePassword',compact('userInfo'));
    }

    /**
     * Update Password
     *
     * @param  Request $request
     * @param  $id
     * @return Response
     */ 
    public function updatePassword(Request $request)
    {
        $id = Auth::user()->id;
        $oldPass = $request->input('oldPassword');
        $newPass = $request->input('newPassword');
        $confirmPass = $request->input('confirmPassword');

        $request->validate(['oldPassword'=>'required',
        'newPassword'=>'required|min:8|regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d).+$/',
        'confirmPassword'=>'required|same:newPassword']);
        
        $user = User::where('id',$id)->select('firstname','lastname','email','password')->first();
        $hashed_password = Hash::check($oldPass, $user->password);

        $firstname = $user->firstname;
        $lastname = $user->lastname;   
        if($hashed_password)
        {
            if($newPass === $confirmPass)
            {
                $new_password = Hash::make($newPass); //Encrypting password
                if(DB::table('users')
                ->where('id', $id)
                ->update(['password' => $new_password, 'updated_at' => date("Y-m-d H:i:s")]))
                {
                    DB::table('user_logins')
                    ->where('user_id',Auth::user()->id)
                    ->update(['logout_time' => date("Y-m-d H:i:s"), 'updated_at' => date("Y-m-d H:i:s")]);
                    Session::flush();
                    Session::flash('Success', 'Your Password has been updated.Please login again.'); 
                    return redirect('/');
                }
                else{
                    Session::flash('Error', 'Something went wrong !'); 
                }   
            }
            else{
                Session::flash('Error', 'New Password and Confirm Password does not match!');
            }

        }   
        else
        {
            Session::flash('Error', 'Old Password Does Not Match!');
        }      
        return Redirect::route('changePassword',[Auth::user()->id]);
    }


    /**
     * Get User Profile View 
     *
     * @param  $id
     * @return Response
     */ 
        public function profileSettings()
        {
            $id = Auth::user()->id;
            $userInfo = User::where('id',$id)->get()->toArray();
            return view('users.profile',compact('userInfo'));
        }

    /**
     * Get Edit Profile View
     *
     * @param  $id
     * @return Response
     */ 
        public function editProfileIndex()
        {   
            $id = Auth::user()->id;
            $userInfo = User::where('id',$id)->get()->toArray();
            return view('users.editProfile',compact('userInfo'));
        }

    /**
     * Update User Profile
     *
     * @param  Request  $request
     * @param  $id
     * @return Response
     */ 
    public function updateProfile(Request $request)
    {
        $id = Auth::user()->id;
        $request->validate(['firstname'=>'required',
        'lastname'=>'required',
        'address'=> 'required',
        'city'=> 'required',
        'mobile'=>'required|unique:users,mobile',
        'document' => 'mimes:jpeg,pdf,jpg|max:1024',
        'document2' => 'mimes:jpeg,pdf,jpg|max:1024',
        'profile_pic' => 'mimes:jpeg,jpg|max:1024',
        'emirates_id_expiration_date' => 'required'
        ]);
        
        $user = User::where('id',$id)->first();
      
        $mobile = str_replace(' ','',$request->input('mobile'));
      
        $user_id = Auth::user()->id;
        $user_type = Auth::user()->user_type_id;
        $updated_at = date("Y-m-d H:i:s");
        //Uploading Profile Pic
        if($request->profile_pic != "")
        {
            $picName = $mobile.'_'.$id.time().'.'.$request->profile_pic->getClientOriginalExtension();
            if($user_type == env('USER_TYPE_LANDLORD')){
                $folder_name = "landlord";
                $path = public_path('media/landlord/'.$user_id);
            }

            if($user_type == env('USER_TYPE_TENANT')){
                $folder_name = "tenant";
                $path = public_path('media/tenant/'.$user_id);
            }
    
            if(!is_dir($path)){
                File::makeDirectory($path);
            }
            $request->profile_pic->move($path, $picName);
        
            $document_path = 'media/'.$folder_name.'/'.$user_id.'/'.$picName;
            
            DB::table('users')
                ->where('id', $user_id)
                ->update(['profile_pic' => $document_path,'updated_at'=>$updated_at]);

            Auth::user()->profile_pic = $document_path;
        }

        //if($user_type == env('USER_TYPE_TENANT')){
            //Uploading updated passport scan copy of tenant
            
            if($request->document != "")
            {
                $imageName = $mobile.'_'.time().'.'.$request->document->getClientOriginalExtension();
                
                if($user_type == env('USER_TYPE_LANDLORD'))
                    $path = public_path('media/landlord/'.$user_id);
                else
                    $path = public_path('media/tenant/'.$user_id);


                $request->document->move($path, $imageName);
                
                if($user_type == env('USER_TYPE_LANDLORD'))
                    $document_path = 'media/landlord/'.$user_id.'/'.$imageName;
                else
                    $document_path = 'media/tenant/'.$user_id.'/'.$imageName;
                
                DB::table('users')
                    ->where('id', $user_id)
                    ->update(['document' => $document_path,'updated_at'=>$updated_at]);
            }
        //}
        if($user_type == env('USER_TYPE_LANDLORD')){
            if($request->document2 != ""){
                    $passport_copy_name = $mobile.'_'.time().'.'.$request->document2->getClientOriginalExtension();                  
                    $path = public_path('media/landlord/'.$user_id);
                    $request->document2->move($path, $passport_copy_name);        
                    $document2_path = 'media/landlord/'.$user_id.'/'.$passport_copy_name;  

                    DB::table('users')
                        ->where('id', $user_id)
                        ->update(['passport' => $document2_path,'updated_at'=>$updated_at]);
                }
        }
        $user->update(['firstname'=>$request->input('firstname'),
                        'lastname'=>$request->input('lastname'),
                        'address'=>$request->input('address'),
                        'city'=>$request->input('city'),
                        'dob'=>$request->input('dob'),
                        'short_bio'=>$request->input('bio'),
                        'facebook_profile'=>$request->input('fb'),
                        'linkedin_profile'=>$request->input('lin'),
                        'updated_at'=>$updated_at,
                        'emirates_id_expiration_date'=>$request->input('emirates_id_expiration_date'),
                    ]); 
        
        Auth::user()->firstname = $request->input('firstname');
        Auth::user()->lastname =  $request->input('lastname');

        if($user->mobile != $mobile)
        {  
            $country_code = $user->country_code;
            /* Sending OTP for verifying mobile number */
            $otp = rand(100000, 999999);
            $msg_body = "Please use ".$otp." as OTP for verifying your mobile number";
            $recipients = $country_code.$mobile;
            $response = Controller::SendSMS(env('SMS_API_URL'), env('SMS_USERNAME'), env('SMS_PASSWORD'), $msg_body, env('SMS_MSG_ENCODING'), env('SMS_COUNTRY_CODE'), env('SMS_AREA_CODE'), $recipients, env('SMS_HEADER'));
            
            $response_array = explode('=', $response);
            
            $sms_data['user_id'] = $user_id;
            $sms_data['recipient'] = $recipients;
            $sms_data['message'] = $msg_body;
            $sms_data['message_id'] = '';
            $error = substr($response_array[1],0,1);
            # if there is not error then save SMS to sms_reports table
            if($error == 0){                    
                $sms_data['message_id'] = preg_replace('/(<BR>)+$/', '', $response_array[2]);
                #Creating object for sms_report model
                $sms_report = new SmsReport;
                $sms_report->fill($sms_data);
                $sms_report->save($sms_data);

            }
                
            $user->update(['mobile'=>$mobile,'is_mobile_verified'=>0,'otp'=>$otp,'updated_at'=>$updated_at]);
            session()->put('profile_updated','profile_updated');
            Auth::user()->otp = $otp;
            Session::flash('Success', 'You have updated your mobile number, Please verify it'); 
            return redirect('/users/verify');
        }
        

        Session::flash('Success','Profile Updated Successfully');
        return Redirect::route('profile');
    }


    /**
     * Getting all messages of logged in user
     *
     * @param  $id
     * @return Response
     */ 
    public function getMessages()
    {
        $user_id = Auth::user()->id;
        $user_details = User::findOrFail($user_id);
        return view('users.messages',compact('user_details'));
    }

    /**
     * Marking message as read
     *
     * @param  $id
     * @return Response
     */ 
    public function messageRead($id)
    {
        $user_id = Auth::user()->id;
        $user = User::findOrFail($user_id);
      
        $notification = $user->notifications()->where('id',$id)->first();

        if ($notification)
        {
            $notification->markAsRead();
        }

        if(Auth::user()->user_type_id == env('USER_TYPE_TENANT')){
            if(isset($notification->data['bid_id']) && !empty($notification->data['bid_id'])){
                $toId = $notification->data['bid_id'];
                return redirect('biddings/bids#'.$toId);
            }
            
        }

        if(Auth::user()->user_type_id == env('USER_TYPE_LANDLORD')){
            if(isset($notification->data['contract_id']) && !empty($notification->data['contract_id'])){
                return redirect('contracts');
            }
            if(isset($notification->data['property_id']) && !empty($notification->data['property_id'])){
                $toId = $notification->data['property_id'];
                return redirect('biddings/property-biddings/'.base64_encode($toId).'/'.base64_encode($user_id));
            }
            
        }
        
        
        
    }

    /**
     * Opt-out Tenant from Bidding
     *
     * @param  $id
     * @return Response
     */ 
    public function optOut(Request $request)
    {
        $bid_id = $request->input('bid_id');
        $bidding_details = Biddings::instance()->getBid($bid_id);
        if(!empty($bidding_details)){
            $updated_at = date("Y-m-d H:i:s");
            DB::table('biddings')
                ->where('id', $bid_id)
                ->update(['bid_status_id'=>55,'bid_selection_time'=>NULL,'updated_at'=>$updated_at]);
           
            $property = Property::where('id', $bidding_details['property_id']);

            $property->update(['bid_selected'=>0,'updated_at'=>$updated_at]);
            $property = $property->first()->toArray();
            
            /* Sending Notification to the owner */
            $user_id = $property['landlord_id'];
            $user_detail = User::findOrFail($user_id);
            $tenant_name = $bidding_details['tenant']['firstname']." ".$bidding_details['tenant']['lastname'];
            
            $post['bid_id'] = '' ;
            $post['property_id'] = $bidding_details['property_id'];
            $post['type_id'] = env('MESSAGE_TYPE_BID');
            $post['message'] = $tenant_name.' has opt-out from the bid';
            $user_detail->notify(new \App\Notifications\PostNewNotification($post));

            /**Change status of other bids for this property to 'Active' */
            $otherBids = Bidding::where('property_id',$bidding_details['property_id'])
                                ->where('bid_status_id','!=',55)    
                                ->where('tenant_id','!=',$bidding_details['tenant_id'])
                                ->update(['bid_status_id'=>56,'updated_at'=>$updated_at]);

            Session::flash('Success','You have successfully opted-out.');
        }
        else{
            Session::flash('Error','Something went wrong !');   
        }
        return redirect()->back();

    }

    public function myPlaceIndex()
    {
        $user_id = Auth::user()->id;
        $user_type = Auth::user()->user_type_id;

        if($user_id && $user_type == env('USER_TYPE_TENANT'))
        {
            $bid_status_id_arr = array('51','54','53','64');
            $properties = Bidding::with(array('TenancyContract','Property'=>function($query){
                                        $query->with(array('BedroomSize','WashroomSize','PropertyTerm',
                                            'Media'=>function($query){
                                                $query->get();
                                        }));
                                    }))
                                    ->where('tenant_id',$user_id)
                                    ->whereIN('bid_status_id',$bid_status_id_arr)
                                    ->get()->toArray();
        }
      
        return view('users.myPlace',compact('properties'));
    }

    public function supportRequest(Request $request)
    {
        $request->validate([
                'subject'=>'required',
                'description' => 'required|string|min:1|max:1500',
                'bid_id' => 'required',
                'property_id' => 'required'
        ]);

        $support = new Support;
        $support->subject = $request->subject;
        $support->description = $request->description;
        $support->bid_id = $request->bid_id;
        $support->property_id = $request->property_id;
        $support->user_id = Auth::user()->id;
        $support->status = 0;
        $support->created_at = date("Y-m-d H:i:s");
        $support->updated_at = date("Y-m-d H:i:s");
        $support->save();
        
        Session::flash('Success','Your Request has been sent.');
        return redirect()->back();
    }

    #Code for Admin Section 

    /**
     * Get user details for contract.
     *
     * @return \Illuminate\Http\Response
     */
    public function userDetails($user_id)
    {
        $user = User::findOrFail($user_id)
                            ->toArray();
        //Return reponse object to prevent controller from trying to render a view
        return response()->json($user);
    }

    //For generating random password
    private function generateRandomPassword($length) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    /**
     * Get user details for contract.
     *
     * @return \Illuminate\Http\Response
     */
    public function adminAddUser(Request $request)
    {
       
        $password = $this->generateRandomPassword(10);
        
        //Validating data entered by user
        $request->validate(['firstname'=>'required',
            'lastname'=>'required',
            'email'=>'required|email|unique:users,email',
            'country_code'=>'required',
            'mobile'=>'required|unique:users,mobile',
            'user_type'=>'required',
            'address'=>'required',
            'city'=>'required',
            'document' => 'mimes:jpeg,pdf,jpg|max:1024',
        ]);

        //Creating object of User Model                
        $user = new User;

        //Setting data array
        $data['created_at'] = date("Y-m-d H:i:s");
        $data['updated_at'] = date("Y-m-d H:i:s");
        $user->firstname = $firstname = $data['firstname'] = $request->input('firstname');
        $user->lastname = $lastname = $data['lastname'] = $request->input('lastname');
        $user->email = $data['email'] = $request->input('email');
        $user->password = $data['password'] = Hash::make($password);
        $country_code = $user->country_code = $data['country_code'] = $request->input('country_code');
        $mobile_number = $user->mobile = $data['mobile'] = $request->input('mobile');
        $user->user_type_id = $user_type_id = $data['user_type_id'] = $request->input('user_type');
        $user->is_mobile_verified = $data['is_mobile_verified'] = 0;
        $user->address = $data['address'] = $request->input('address');
        $user->city = $data['city'] = $request->input('city');
        $user->status = $data['status'] = 1;
        $otp = rand(100000, 999999);
        $user->otp = $data['otp'] = $otp;
        $user->document = $data['document'] = '';

        if($user_type_id ==3 && $request->document){
            //Uploading passport scan copy of tenant
            $imageName = $request->input('mobile').'_'.time().'.'.$request->document->getClientOriginalExtension();
        }
        
        $user->save(); // This will also auto-update the user_count in user_types table
        $user_id = $user->id;
        
        if($user_type_id ==3){
            if(!empty($data['document'])){
                $folderpath = 'media/tenant';
                if(!is_dir($folderpath)){
                    File::makeDirectory($folderpath);
                }
                $path = public_path($folderpath.'/'.$user_id);
              
                File::makeDirectory($path);
                $request->document->move($path, $imageName);

                $document_path = 'media/tenant/'.$user_id.'/'.$imageName;

                DB::table('users')
                    ->where('id', $user_id)
                    ->update(['document' => $document_path]);    
            }
        }
        $data = array('first_name'=>$request->firstname, 'last_name'=>$request->lastname,'email'=>$user->email,'password'=>$password);
		Mail::send('mail', $data, function($message) use ($data) {
			$message->to($data['email'], 'Bid2Rent')->subject
				('Account Created');
			$message->from(env('MAIL_USERNAME'),'Bid2Rent');
		});

        Session::flash('Success','User added successfully. Email has been sent to the user');
        return redirect()->back();
    }
}