<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Component\Bidding\Biddings as Biddings;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Input;
use App\Models\Transaction; 
use App\Models\Bidding; 
use App\Models\Property; 
use App\Models\User; 
use App\Models\PaymentStatus; 
use Session;
use Excel;
use Cache;
class TransactionsController extends MailsController
{
    /**
     * Displaying the view for completing transaction
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {   
        $bid_id = $request->input('bid_id');

        Bidding::where('id', $bid_id)
                    ->update(['bid_status_id'=> 50]);

        $bidding_details = Biddings::instance()->getBid($bid_id);

        /* Sending Notification to the bidder */
        $user_detail = User::findOrFail($bidding_details['tenant_id']);

        $post['bid_id'] = $bid_id;
        $post['property_id'] = '';
        $post['type_id'] = env('MESSAGE_TYPE_BID');
        $post['message'] = 'Your bid status against property '.$request->input('property_name').' has been updated to Commission Pending';
        $user_detail->notify(new \App\Notifications\PostNewNotification($post));

        /* Setting transaction table data array */
        $commission_percent = env('COMMISSION_PERCENTAGE');
        $amount = $bidding_details['propose_rent']*($commission_percent/100);
        $transaction_data['model_id'] = env('BIDDING');
        $transaction_data['amount'] = $amount;
        $transaction_data['payment_method_code'] = 'Telr';
        $transaction_data['payment_status_id'] = 1;
        $transaction_data['reference_id'] = 0;
        $transaction_data['user_id'] = $bidding_details['tenant_id'];
        $transaction_data['parent_id'] = $bidding_details['id'];
        $transaction_data['custom_1'] = 'NULL';
        $transaction_data['custom_2'] = 'NULL';
        $transaction_data['custom_3'] = 'NULL';

        $transaction = new Transaction;
        $transaction->fill($transaction_data);
        $transaction->save();
        $transaction_id = $transaction->id;
        
        $tran_id = base64_encode($transaction_id);

        $log_file = storage_path('logs/'.date("d-m-Y").'_TransactionLogs');
        Controller::write_log($log_file, date('d-m-Y H:i:s').' : Log Start for Transaction ID ----> '.$transaction_id);

        $params = array(
            'ivp_method' => 'create',
            'ivp_store' => 18973,
            'ivp_authkey' => 'rCTX@9xRTT~fSqHS',
            'ivp_cart' => $transaction_id,
            'ivp_test' => '1',
            'ivp_amount' => $amount,
            'ivp_currency' => 'AED',
            'ivp_desc' => 'Bid Commission Payment',
            'return_auth' => env('APP_URL').'/transactions/response/'.$tran_id,
            'return_can' => env('APP_URL').'/transactions/response/'.$tran_id,
            'return_decl' => env('APP_URL').'/transactions/response/'.$tran_id,
            'bill_fname' => $bidding_details['tenant']['firstname'],
            'bill_sname' => $bidding_details['tenant']['lastname'],
            'bill_addr1' => $bidding_details['tenant']['address'],
            'bill_city' => $bidding_details['tenant']['city'],
            'bill_country' => 'AE',
            'bill_email' => $bidding_details['tenant']['email'],
            );
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://secure.telr.com/gateway/order.json");
            curl_setopt($ch, CURLOPT_POST, count($params));
            curl_setopt($ch, CURLOPT_POSTFIELDS,$params);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:'));
            $results = curl_exec($ch);
            curl_close($ch);

            Controller::write_log($log_file, date('d-m-Y H:i:s').' : Request for Transaction ID ----> '.$transaction_id);
            Controller::write_log($log_file, date('d-m-Y H:i:s').' : Response ----> '.$results);
            Controller::write_log($log_file, ' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
            $results = json_decode($results,true);

           if(isset($results['order'])){
                $ref= trim($results['order']['ref']);
                $url= trim($results['order']['url']);
                if (empty($ref) || empty($url)) {
                    # Failed to create order
                }
                else{
                    # Updating Transaction Status => Payment Completed
                    $transaction_details = Transaction::findOrFail($transaction_id);
                    $transaction_details->reference_id = $ref;
                    $transaction_details->save();
                    return redirect($url);
                }
           }
           else{
                Session::flash('Error','Something went wrong');
                return redirect()->back();
           }
            
    }

    /**
     * View for payment gateway input fields
     *
     * @return \Illuminate\Http\Response
     */
    public function form($transaction_id)
    {
        $transaction_details = Transaction::with('User')
                                            ->findOrFail(base64_decode($transaction_id))
                                            ->toArray();
        return view('transactions/form', compact('transaction_details','transaction_id'));        
    }

    /**
     * Returning after completing the payment
     *
     * @return \Illuminate\Http\Response
     */
    public function response($tran_id)
    {
        $transaction_id = base64_decode($tran_id);
        $transaction_details = Transaction::findOrFail($transaction_id);
        $order_ref = $transaction_details->reference_id;
        $bid_id = $transaction_details->parent_id;
        
        $params = array(
            'ivp_method' => 'check',
            'ivp_store' => 18973,
            'ivp_authkey' => 'rCTX@9xRTT~fSqHS',
            'order_ref' => $order_ref
            );
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://secure.telr.com/gateway/order.json");
        curl_setopt($ch, CURLOPT_POST, count($params));
        curl_setopt($ch, CURLOPT_POSTFIELDS,$params);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:'));
        $results = curl_exec($ch);
        curl_close($ch);

        $log_file = storage_path('logs/'.date("d-m-Y").'_TransactionLogs');
        Controller::write_log($log_file, date('d-m-Y H:i:s').' : Redirect Response for Transaction ID ----> '.$transaction_id);
        Controller::write_log($log_file, date('d-m-Y H:i:s').' : Response ----> '.$results);
        Controller::write_log($log_file, ' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');

        $results = json_decode($results,true);
        $order_status_code = $results['order']['status']['code'];
        if(isset($results['order']['transaction']))
            $order_transaction_status = $results['order']['transaction']['status'];
        else
            $order_transaction_status = '';
                
        if($order_status_code == 3 && $order_transaction_status=='A'){
            # Updating Transaction Status => Payment Completed
            $transaction_details->payment_status_id = 3;
            $transaction_details->save();

            #Updating Bidding Status => Commission Paid
            $bidding_details = Bidding::select('id','property_id')->findOrFail($bid_id);
            $bidding_details->bid_status_id = 51; //commission paid
            $bidding_details->update();

            $property_id = $bidding_details->property_id;
            Bidding::where('property_id', $property_id)
                        ->where('id', '!=', $bid_id)
                        ->update(['bid_status_id'=> 49]);
            $biddings = Bidding::with('property')
                                ->where('property_id', $property_id)
                                ->where('id','!=',$bid_id)
                                ->get();
            
            foreach($biddings as $bid){
                $property_name = $bid->property->name;
                $user_id = $bid->tenant_id;
                $user_detail = User::findOrFail($user_id);

                $tenant_email = $user_detail->email;
                $tenant_name = $user_detail->firstname.' '.$user_detail->lastname;

                // sending email to tenants
                $mail_result = $this->bid_reject($tenant_email, $tenant_name, $property_name);

                $post['bid_id'] = $bid->id;
                $post['property_id'] = $bid->property_id;
                $post['type_id'] = env('MESSAGE_TYPE_BID');
                $post['message'] = 'Your bid has been rejected ';
                $user_detail->notify(new \App\Notifications\PostNewNotification($post));
            }

            #Updating property Status => Property Closed
            $property_details = Property::where('id', $property_id)->first();
            $property_details->update(['property_status_id' => 5]);

            /* Sending Notification to the bidder */
            $user_id = $property_details['landlord_id'];
            $user_detail = User::findOrFail($user_id);

            $post['bid_id'] = $bid_id;
            $post['property_id'] = $property_id;
            $post['type_id'] = env('MESSAGE_TYPE_BID');
            $post['message'] = 'Bidder has paid the commision fees against property '. $property_details['name'];
            $user_detail->notify(new \App\Notifications\PostNewNotification($post));
            
            //set bid id in session for survey 
            Session::put('survey_parent',$bid_id);
            Session::flash('Success', 'You have successfully made the payment');
        }
        elseif($order_status_code == 2 && $order_transaction_status=='H'){
            # Updating Transaction Status => Payment Holds
            $transaction_details->payment_status_id = 6;
            $transaction_details->save();

            //set bid id in session for survey 
            Session::put('survey_parent',$bid_id);
            Session::flash('Success', 'Your payment has been authorised but it is on hold');
        }
        elseif($order_status_code == -1){
            # Updating Transaction Status => Payment Expired
            $transaction_details->payment_status_id = 4;
            $transaction_details->save();

            //set bid id in session for survey 
            Session::put('survey_parent',$bid_id);
            Session::flash('Error', 'Your payment has been expired');
        }
        elseif($order_status_code == -2){
            # Updating Transaction Status => Payment Cancelled
            $transaction_details->payment_status_id = 5;
            $transaction_details->save();

            //set bid id in session for survey 
            Session::put('survey_parent',$bid_id);
            Session::flash('Error', 'Your payment has been cancelled');
        }
        elseif($order_status_code == -3){
            # Updating Transaction Status => Payment Failed
            $transaction_details->payment_status_id = 2;
            $transaction_details->save();

            //set bid id in session for survey 
            Session::put('survey_parent',$bid_id);
            Session::flash('Error', 'Your payment has been declined');
        }        
        return redirect('/biddings/bids/?#survey');
    }

    
    #Admin section actions starrt here
    /**
     * all transactions list
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function adminGetTransactions()
    {
        $user_id = 0;
        $payment_status_id = 0;
        $start_date = '';
        $end_date = '';

        if($_SERVER['REQUEST_METHOD']=='POST'){            
            $user_id = (isset($_POST['user_id'])) ? $_POST['user_id']:0;
            $payment_status_id = (isset($_POST['payment_status_id'])) ? $_POST['payment_status_id']:0; 
            $start_date = (!empty($_POST['start_date'])) ? date("Y-m-d", strtotime($_POST['start_date'])) : '';
            $end_date = (!empty($_POST['end_date'])) ? date("Y-m-d", strtotime($_POST['end_date'])) : '';
        }

        /* Getting filter parameters for pagination */
        if(isset($_GET['user_id']) && !empty($_GET['user_id']))
            $user_id = $_GET['user_id'];
        if(isset($_GET['payment_status_id']) && !empty($_GET['payment_status_id']))
            $payment_status_id = $_GET['payment_status_id'];
        if(isset($_GET['start_date']) && !empty($_GET['start_date']))
            $start_date = date("Y-m-d", strtotime($_GET['start_date']));
        if(isset($_GET['end_date']) && !empty($_GET['end_date']))
            $end_date = date("Y-m-d", strtotime($_GET['end_date']));
        /* Ends Here */

        $transactions = Transaction::with('User:id,firstname,lastname','PaymentStatus:id,status')
                                    //->orderBy('id','desc')
                                    ->when($user_id, function ($query) use ($user_id) {
                                        return $query->where('user_id',$user_id);
                                    })
                                    ->when($payment_status_id, function ($query) use ($payment_status_id) {
                                        return $query->where('payment_status_id',$payment_status_id);
                                    })
                                    ->when($start_date, function ($query) use ($start_date,$end_date) {
                                        return $query->whereBetween('created_at',[date("Y-m-d", strtotime($start_date)),date("Y-m-d", strtotime($end_date."+1 day"))]);
                                    })
                                    ->sortable(['id'=>'desc'])
                                    ->paginate(10);

        $payment_status = PaymentStatus::all();
        /*$users = User::select('id','firstname','lastname','email')
                        ->orderBy('firstname')
                        ->where('user_type_id',env('USER_TYPE_TENANT'))
                        ->get();*/
        $users = Cache::remember('tenant', env('CACHE_TIME'), function()
        {
            return User::select('id','firstname','lastname','email')->where('user_type_id',env('USER_TYPE_TENANT'))->orderBy('firstname')->get()->toArray();
        });

        return view('/admin/transactions-list', compact('transactions','user_id','payment_status_id','start_date','end_date','users','payment_status'));
    }


    /**
     * Exporting Transactions to Excel
     *
     * @param 
     *
     * @return Illuminate\View\View
     */
    public function adminExportTransactions($user_id,$payment_status_id,$start_date=null,$end_date=null)
    {
        if(!empty($start_date))
            $start_date = date("Y-m-d", strtotime($start_date));
        if(!empty($end_date))
            $end_date = date("Y-m-d", strtotime($end_date));

        $transactions = Transaction::with('User:id,firstname,lastname,email,country_code,mobile,address,city','PaymentStatus:id,status')
                                    ->orderBy('id','desc')
                                    ->when($user_id, function ($query) use ($user_id) {
                                        return $query->where('user_id',$user_id);
                                    })
                                    ->when($payment_status_id, function ($query) use ($payment_status_id) {
                                        return $query->where('payment_status_id',$payment_status_id);
                                    })
                                    ->when($start_date, function ($query) use ($start_date,$end_date) {
                                        return $query->whereBetween('created_at',[date("Y-m-d", strtotime($start_date)),date("Y-m-d", strtotime($end_date."+1 day"))]);
                                    })
                                    ->get()
                                    ->toArray();
        
        Excel::create('TransactionsReport', function($excel) use ($transactions){
            $excel->sheet('property', function($sheet) use ($transactions){                
                $sheet->row(1,array('Transaction ID', 'Tenant Name', 'Email', 'Country Code','Mobile','Address','City','Amount', 'Status', 'DateTime'));
                $i=2;
                foreach($transactions as $transaction){
                    $sheet->row($i, array($transaction['id'], $transaction['user']['firstname'].' '.$transaction['user']['lastname'], $transaction['user']['email'], $transaction['user']['country_code'], $transaction['user']['mobile'],$transaction['user']['address'],$transaction['user']['city'],$transaction['amount'], $transaction['payment_status']['status'], $transaction['created_at'] ));
                    $i++;
                }
            });
        })->export('xls');
        die();
    }




}
