<?php

namespace App\Http\Controllers;
use Cache;
use Excel;
use DB;
use File;
use Session;
use Redirect;
use Auth;
use Image;
use Mail;
use App\Models\AppCode;
use App\Models\Amenity;
use App\Models\AmenityProperty;
use App\Models\Bidding;
use App\Models\Lanlord;
use App\Models\Emirate;
use App\Models\Property;
use App\Models\BedroomSize;
use Illuminate\Http\Request;
use App\Models\PropertyType;
use App\Models\PropertyView;
use App\Models\WashroomSize;
use App\Models\VieweingOption;
use App\Models\PropertyStatus;
use App\Models\NumberofPayment;
use App\Models\Media;
use App\Models\User;
use App\Models\TenancyContract;
use App\Http\Controllers\Controller;
use App\Models\Survey;
use App\Component\Property\Properties as Properties;
use PDF;
use DateTime;
use DateInterval;

class TestsController extends Controller{

  public function pdf(){
    /*$pdf = PDF::loadView('testpdf');
    $pdf->save($_SERVER['DOCUMENT_ROOT']."/bid2rent/public/media/contract/test.pdf");*/

    $contract_id = 8;

      /* Fetching contract details with landlord details */
      $contract_detail = TenancyContract::Select('id','tenant_id','landlord_id','bid_id')->with('landlord:id,firstname,lastname,email')->where('id', $contract_id)
                          ->first()
                          ->toArray();
      /* Selecting bid_id, property_id & property_name to be set in mail notification */
      $bidding_detail = Bidding::Select('id','property_id')->where('id', $contract_detail['bid_id'])
              ->with('Property:id,name')
              ->first()
              ->toArray();            
      $property_name = $bidding_detail['property']['name'];

      /* Calculating end date of contract */
      $end_date = $this->endCycle(date("Y-m-d"), 12);            

      /* Updating contract starting date & end date in bddings table */
      $bid = new Bidding;
      $bid->where('id',$contract_detail['bid_id'])
          ->update(['bid_status_id'=>64]);

      /* Updating the status of landlord acceptance */
      $tenancy_contract = new TenancyContract;
      $tenancy_contract->where('id',$contract_id)
          ->update(['landlord_accept_status'=>1]);

      /* Notifying tenant about the acceptance */
      $tenant_detail = User::findOrFail($contract_detail['tenant_id']);
      $tenant_name = $tenant_detail['firstname']." ".$tenant_detail['lastname'];
      $tenant_email = $tenant_detail['email'];            
      $post['bid_id'] = $contract_detail['bid_id'];
      $post['property_id'] = '';
      $post['contract_id'] = $contract_id;
      $post['type_id'] = env('MESSAGE_TYPE_CONTRACT');
      $post['message'] = 'Landlord has accepted the tenancy contract for property'.$property_name;
      $tenant_detail->notify(new \App\Notifications\PostNewNotification($post));

      /* Loading contract details to be set on pdf view file */            
      $bidding_detail = Bidding::where('id', $contract_detail['bid_id'])
              ->with(array(
                  'TenancyContract',
                  'Property'=>function($query){
                      $query->with('PropertyTerm:id,term_id,property_id');
                  },
              ))
              ->first()
              ->toArray();                    
      $terms_conditions = AppCode::termsCondition()->orderBy('sort_order')->pluck('name','id')->all();
      /* setting pdf name */
      $pdf_name = $contract_id.'_'.time().'.pdf';
      /* path to save the pdf */
      $dir = public_path('/media/contract/'.$contract_detail['landlord_id']);
      //$dir = $_SERVER['DOCUMENT_ROOT']."/bid2rent/public/media/contract/".$contract_detail['landlord_id'];
      if(is_dir($dir)){
          /* generating pdf from view */
          $pdf = PDF::loadView('contracts.view-contract-form',compact('data','bidding_detail','terms_conditions'));
          $pdf->save($dir.'/'.$pdf_name);
      }
      else{
          mkdir($dir);
          /* generating pdf from view */
          $pdf = PDF::loadView('contracts.view-contract-form',compact('data','bidding_detail','terms_conditions'));
          $pdf->save($dir.'/'.$pdf_name);
      }
      /* full path of pdf file */
      //$pdf_path = $dir.'/'.$pdf_name; 

      return $pdf->download();
    die();
  }

/**
     * support function to calculate end date
     *
     * @return void
     */

      public function endCycle($end_date, $months)
        {
            $date = new DateTime($end_date);

            // call second function to add the months
            $newDate = $date->add($this->add_months($months, $date));

            // goes back 1 day from date, remove if you want same day of month
            $newDate->sub(new DateInterval('P1D'));

            //formats final date to Y-m-d form
            $dateReturned = $newDate->format('Y-m-d');

            return $dateReturned;
        }
/**
     * support function to add specific months
     *
     * @return void
     */
      private function add_months($months, DateTime $dateObject)
        {
            $next = new DateTime($dateObject->format('Y-m-d'));
            $next->modify('last day of +'.$months.' month');

            if($dateObject->format('d') > $next->format('d')) {
                return $dateObject->diff($next);
            } else {
                return new DateInterval('P'.$months.'M');
            }
        }
        
  public function listing()
    { 
      $current_date = '2018-12-21';
      $biddings_detail = Bidding::with('property:id,name','tenant:id,firstname,lastname,email')->where('tenancy_contract_end_date','>=',$current_date)->get()->toArray();
            foreach($biddings_detail as $bid){
                if(strtotime($current_date) == strtotime(date('Y-m-d', strtotime("-2 months -15 days", strtotime($bid['tenancy_contract_end_date']))))){
                    
                    echo 'Notification will send to User ID '. $bid['tenant_id'];                    

                    $data = array('tenant_name'=>$bid['tenant']['firstname'].' '.$bid['tenant']['lastname'], 'tenant_email'=>$bid['tenant']['email'], 'property_name' =>$bid['property']['name']);
                                       
                    // Mail::send('tenancyContractExpired', $data, function($message) use ($data) {
                    //     $message->to($data['tenant_email'], 'Bid2Rent')->subject
                    //         ('Bid Retired');
                    //     $message->from(env('MAIL_USERNAME'),'Bid2Rent');
                    // });

                }
            }
            echo '<pre>';
            print_r($biddings_detail); die();

      if(isset($_REQUEST['keyword']) && !empty($_REQUEST['keyword']))
        $keyword = $address = $_REQUEST['keyword'];

      if(isset($_REQUEST['lat']) && !empty($_REQUEST['lat']))
        $lat = $_REQUEST['lat'];

      if(isset($_REQUEST['lng']) && !empty($_REQUEST['lng']))
        $lng = $_REQUEST['lng'];

      $bedroom_size_id = $washroom_size_id = $property_type = $emirates_id = $min_price = $max_price = '';

      if(isset($_REQUEST['search'])){
        $bedroom_size_id = (isset($_REQUEST['bedrooms'])) ? $_REQUEST['bedrooms'] : '';
        $washroom_size_id = (isset($_REQUEST['bathrooms'])) ? $_REQUEST['bathrooms'] : '';
        $property_type_id = (isset($_REQUEST['category'])) ? $_REQUEST['category'] : '';
        $emirates_id = (isset($_REQUEST['emirates'])) ? $_REQUEST['emirates'] : '';
        $number_of_payments_id = (isset($_REQUEST['payments'])) ? $_REQUEST['payments'] : '';
        $amenities_id = (isset($_REQUEST['amenities'])) ? implode(',', $_REQUEST['amenities']):'';
        $min_price = $_REQUEST['value-min'];
        $max_price = $_REQUEST['value-max'];
      }
      /*$properties = Property::with('AmenityProperty')
                                ->select('properties.id','latitude','longitude','properties.address',
                                   DB::raw("
                                    ( 6371 * acos( cos( radians(".$lat.") ) *
                                      cos( radians( latitude ) )
                                      * cos( radians( longitude ) - radians(".$lng.")
                                      ) + sin( radians(".$lat.") ) *
                                      sin( radians( latitude ) ) )
                                    ) AS distance" 
                                ))
                                ->where('property_status_id',1)
                                ->having("distance", "<", 50)
                                ->orderBy("distance")                             
                                ->get()
                                ->toArray();
        echo '<pre>';
        print_r($properties); die;          */                  
        $types = AppCode::PropertyType()->get()->toArray();
        $bedrooms = AppCode::BedroomSizes()->get()->toArray();
        $bathrooms = AppCode::WashroomSizes()->get()->toArray();
        $amenities = Amenity::get()->toArray();
        $emirates = AppCode::emirate()->get()->toArray();
        $payments = AppCode::numberofpayments()->get()->toArray();
      
        $prices = Property::selectRaw('MAX(yearly_price) as max_price')
                            ->selectRaw('MIN(yearly_price) as min_price')
                            ->get()
                            ->toArray();

        return view('properties.new-listing', compact('lat','lng','types','bedrooms','bathrooms','amenities','emirates','payments','keyword','prices','bedroom_size_id','washroom_size_id','property_type_id','emirates_id','amenities_id','number_of_payments_id'));

    }
}


/*namespace App\Http\Controllers;
use Google_Client; 
use Google_Service_Drive;
use Google_Service_AnalyticsReporting;
use Google_Service_AnalyticsReporting_DateRange;
use Google_Service_AnalyticsReporting_Metric;
use Google_Service_AnalyticsReporting_Dimension;
use Google_Service_AnalyticsReporting_DimensionFilter;
use Google_Service_AnalyticsReporting_DimensionFilterClause;
use Google_Service_AnalyticsReporting_ReportRequest;
use Google_Service_AnalyticsReporting_GetReportsRequest;
class AnalyticsController extends Controller
{
    /**
     * Display a listing of the successfully commission paid bids.
     *
     * @return \Illuminate\Http\Response
     */
    /*public function index()
    {
        $_SERVER['DOCUMENT_ROOT']. '/bid2rent/vendor/autoload.php';
        $analytics = $this->initializeAnalytics();
        $response = $this->getReport($analytics);
        $this->printResults($response);
    }*/
 

    /**
     * Initializes an Analytics Reporting API V4 service object.
     *
     * @return An authorized Analytics Reporting API V4 service object.
     */
    /*function initializeAnalytics()
    {

      // Use the developers console and download your service account
      // credentials in JSON format. Place them in this directory or
      // change the key file location if necessary.
      $KEY_FILE_LOCATION = __DIR__ . '/service-account-credentials.json';

      // Create and configure a new client object.
      $client = new Google_Client();
      $client->setApplicationName("Hello Analytics Reporting");
      $client->setAuthConfig($KEY_FILE_LOCATION);
      $client->setScopes(['https://www.googleapis.com/auth/analytics.readonly']);
      $analytics = new Google_Service_AnalyticsReporting($client);

      return $analytics;
    }*/


    /**
     * Queries the Analytics Reporting API V4.
     *
     * @param service An authorized Analytics Reporting API V4 service object.
     * @return The Analytics Reporting API V4 response.
     */
    /*function getReport($analytics) {

      // Replace with your view ID, for example XXXX.
      $VIEW_ID = "169298745";

      // Create the DateRange object.
      $dateRange = new Google_Service_AnalyticsReporting_DateRange();
      $dateRange->setStartDate("7daysAgo");
      $dateRange->setEndDate("today");

      // Create the Metrics object.
      $pageview_count = new Google_Service_AnalyticsReporting_Metric();
      $pageview_count->setExpression("ga:pageviews");
      $pageview_count->setAlias("pageviewcount");

      //Create the browser dimension.
      $browser = new Google_Service_AnalyticsReporting_Dimension();
      $browser->setName("ga:pagePath");
      
      // Create Dimension Filter.
      $dimensionFilter = new Google_Service_AnalyticsReporting_DimensionFilter();
      $dimensionFilter->setDimensionName("ga:pagePath");
      $dimensionFilter->setOperator("EXACT");
      $dimensionFilter->setExpressions(array("/bid2rent/public/"));

      // Create the DimensionFilterClauses
      $dimensionFilterClause = new Google_Service_AnalyticsReporting_DimensionFilterClause();
      $dimensionFilterClause->setFilters(array($dimensionFilter));

      // Create the ReportRequest object.
      $request = new Google_Service_AnalyticsReporting_ReportRequest();
      $request->setViewId($VIEW_ID);
      $request->setDateRanges($dateRange);
      $request->setMetrics(array($pageview_count));
      $request->setDimensions(array($browser  ));
      $request->setDimensionFilterClauses(array($dimensionFilterClause));  

      $body = new Google_Service_AnalyticsReporting_GetReportsRequest();
      $body->setReportRequests( array( $request) );
      return $analytics->reports->batchGet( $body );
    }*/


    /**
     * Parses and prints the Analytics Reporting API V4 response.
     *
     * @param An Analytics Reporting API V4 response.
     */
    /*function printResults($reports) {        
        for ( $reportIndex = 0; $reportIndex < count( $reports ); $reportIndex++ ) {
            $report = $reports[ $reportIndex ];
            $header = $report->getColumnHeader();
            $dimensionHeaders = $header->getDimensions();
            $metricHeaders = $header->getMetricHeader()->getMetricHeaderEntries();
            $rows = $report->getData()->getRows();

            for ( $rowIndex = 0; $rowIndex < count($rows); $rowIndex++) {
              $row = $rows[ $rowIndex ];
              $dimensions = $row->getDimensions();
              $metrics = $row->getMetrics();
              /*for ($i = 0; $i < count($dimensionHeaders) && $i < count($dimensions); $i++) {
                print($dimensionHeaders[$i] . ": " . $dimensions[$i] . "\n");
              }*/

              /*for ($j = 0; $j < count($metrics); $j++) {
                $values = $metrics[$j]->getValues();
                for ($k = 0; $k < count($values); $k++) {
                  $entry = $metricHeaders[$k];
                  return $values[$k];
                  //print($entry->getName() . ": " . $values[$k] . "\n");                  
                }
              }
            }
        }
    }*/
//}
