<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Support;
use App\Models\User;
use Cache;
use Excel;

class SupportsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user_id = 0;
        $start_date = '';
        $end_date = '';

        if($_SERVER['REQUEST_METHOD']=='POST'){            
            $user_id = $_POST['user_id'];
            $start_date = (!empty($_POST['start_date'])) ? date("Y-m-d", strtotime($_POST['start_date'])) : '';
            $end_date = (!empty($_POST['end_date'])) ? date("Y-m-d", strtotime($_POST['end_date'])) : '';
        }
        /* Getting filter parameters for pagination */
        if(isset($_GET['user_id']) && !empty($_GET['user_id']))
            $user_id = $_GET['user_id'];
        if(isset($_GET['start_date']) && !empty($_GET['start_date']))
            $start_date = date("Y-m-d", strtotime($_GET['start_date']));
        if(isset($_GET['end_date']) && !empty($_GET['end_date']))
            $end_date = date("Y-m-d", strtotime($_GET['end_date']));
        /* Ends Here */

        $tenants = Cache::remember('tenant', env('CACHE_TIME'), function()
        {
            return User::select('id','firstname','lastname','email')->where('user_type_id',env('USER_TYPE_TENANT'))->orderBy('firstname')->get()->toArray();
        });

        $requests = Support::with('user:id,firstname,lastname','property:id,name,address','bid:id')
                                ->when($user_id, function ($query) use ($user_id) {
                                    return $query->where('user_id',$user_id);
                                })
                                ->when($start_date, function ($query) use ($start_date,$end_date) {
                                    return $query->whereBetween('created_at',[date("Y-m-d", strtotime($start_date)),date("Y-m-d", strtotime($end_date."+1 day"))]);
                                })
                                //->orderBy('created_at','desc')
                                ->sortable(['id'=>'desc'])
                                ->paginate(10);
        return view('admin.support-requests', compact('requests','user_id','start_date','end_date','tenants'));
    }

     /**
     * Exporting Support Requests to Excel
     *
     * @param 
     *
     * @return Illuminate\View\View
     */
    public function adminExportSupportRequests($user_id,$start_date=null,$end_date=null)
    {
        $conditions = array();

        if(!empty($start_date))
            $start_date = date("Y-m-d", strtotime($start_date));
        if(!empty($end_date))
            $end_date = date("Y-m-d", strtotime($end_date));

        $requests = Support::with('user:id,firstname,lastname','property:id,name,address','bid:id')
                                ->when($user_id, function ($query) use ($user_id) {
                                    return $query->where('user_id',$user_id);
                                })
                                ->when($start_date, function ($query) use ($start_date,$end_date) {
                                    return $query->whereBetween('created_at',[date("Y-m-d", strtotime($start_date)),date("Y-m-d", strtotime($end_date."+1 day"))]);
                                })
                                ->orderBy('created_at','desc')
                                ->get()
                                ->toArray();
            
        Excel::create('SupportRequestsReport', function($excel) use ($requests){
            $excel->sheet('requests', function($sheet) use ($requests){                
                $sheet->row(1,array('ID','Property Name','Property Address', 'Tenant Name', 'Subject', 'Description', 'DateTime'));
                $i=2;
                foreach($requests as $request){
                    $sheet->row($i, array($request['id'], $request['property']['name'], $request['property']['address'], $request['user']['firstname'].' '.$request['user']['lastname'], $request['subject'], $request['description'], date("j F, Y", strtotime($request['created_at']))));
                    $i++;
                }
            });
        })->export('xls');
        die();
    }

}
