<?php

namespace App\Http\Controllers;
use Cache;
use Excel;
use DB;
use File;
use Session;
use Redirect;
use Auth;
use Image;
use Input;
use App\Models\AppCode;
use App\Models\Amenity;
use App\Models\AmenityProperty;
use App\Models\Bidding;
use App\Models\Lanlord;
use App\Models\Emirate;
use App\Models\Property;
use App\Models\BedroomSize;
use App\Models\Page;
use Illuminate\Http\Request;
use App\Models\PropertyType;
use App\Models\PropertyView;
use App\Models\WashroomSize;
use App\Models\VieweingOption;
use App\Models\PropertyStatus;
use App\Models\PropertyTerm;
use App\Models\NumberofPayment;
use App\Models\Media;
use App\Models\User;
use App\Http\Controllers\Controller;
use App\Models\Survey;
use App\Component\Property\Properties as Properties;

class PropertiesController extends MailsController
{   
    /**
     * Show the form for creating a new property.
     *
     * @return Illuminate\View\View
     */
    public function add()
    {
        $amenities = Amenity::select('id','icon_class','name')->where('amenity_status_id',1)->get()->toArray();
        $emirates = AppCode::emirate()->orderBy('name')->pluck('name','id')->all();
        $propertyTypes = AppCode::propertytype()->orderBy('name')->pluck('name','id')->all();
        $vieweingOptions = AppCode::vieweingoption()->orderBy('name')->pluck('name','id')->all();
        $bedroomSizes = AppCode::bedroomsizes()->orderBy('name')->pluck('name','id')->all();
        $washroomSizes = AppCode::washroomsizes()->orderBy('name')->pluck('name','id')->all();
        $number_of_payments = AppCode::numberofpayments()->orderBy('sort_order')->pluck('name','id')->all();
        $terms_conditions = AppCode::termsCondition()->orderBy('sort_order')->pluck('name','id')->all();
		
        $terms_content = Page::where('url_key','terms')
                                ->get()
                                ->first()
                                ->toArray();

        $privacy_content = Page::where('url_key','privacy')
                                ->get()
                                ->first()
                                ->toArray();

        return view('properties.add', compact('amenities','emirates','propertyTypes','vieweingOptions','bedroomSizes','washroomSizes','lanlords','propertyStatuses','number_of_payments','terms_conditions','terms_content','privacy_content','terms_conditions'));
    }

    /**
     * Show the form for updating the property.
     * @param $id
     * @return Illuminate\View\View
     */
    public function editPropertyIndex($id, $landlord_id)
    {
        $id = base64_decode($id);
        if(base64_decode($landlord_id) == Auth::user()->id){
            $amenities = Amenity::select('id','icon_class','name')->where('amenity_status_id',1)->get()->toArray();
            $emirates = AppCode::emirate()->orderBy('name')->pluck('name','id')->all();
            $propertyTypes = AppCode::propertytype()->orderBy('name')->pluck('name','id')->all();
            $vieweingOptions = AppCode::vieweingoption()->orderBy('name')->pluck('name','id')->all();
            $bedroomSizes = AppCode::bedroomsizes()->orderBy('name')->pluck('name','id')->all();
            $washroomSizes = AppCode::washroomsizes()->orderBy('name')->pluck('name','id')->all();
            $number_of_payments = AppCode::numberofpayments()->orderBy('sort_order')->pluck('name','id')->all();        
            $terms_conditions = AppCode::termsCondition()->orderBy('sort_order')->pluck('name','id')->all();

            $properties = Property::with(array('Media','BedroomSize','WashroomSize','AmenityProperty','PropertyType','noOfPayments','PropertyTerm'))->where('id',$id)->get()->toArray();
           
            $amenity_ids = array();
            foreach($properties as $property){
                foreach($property['amenity_property'] as $amenity){
                   $amenity_ids[] = $amenity['amenity_id'];
                }
            }

            $term_ids = array();
            foreach($properties as $property){
                foreach($property['property_term'] as $term){
                   $term_ids[] = $term['term_id'];
                }
            }
           
            $amids = implode(",",$amenity_ids);
            
            $term_id_arr = implode(",",$term_ids);

            $terms_content = Page::where('url_key','terms')
                                ->get()
                                ->first()
                                ->toArray();

            $privacy_content = Page::where('url_key','privacy')
                                ->get()
                                ->first()
                                ->toArray();
            return view('properties.editProperty', compact('amenities','emirates','propertyTypes','vieweingOptions','bedroomSizes','washroomSizes','properties','amids','id','number_of_payments','terms_content','privacy_content','term_id_arr','terms_conditions'));
        }
        else{
            Session::flash('Error','Unauthorised access !');            
            return redirect('/');
        }
    }

    /**
     * Update Property
     * @param $id
     * @param $request 
     * @return Response
     */
    public function updateProperty(Request $request,$id)
    {   
        try {
            
            $property = Property::where('id',$id)->first();

            $data = $this->getData($request); //Validating request data
            if($data['property_term_id'] == 1)
                $data['property_term_period'] = $data['short_property_term_period'];
            else
                $data['property_term_period'] = $data['long_property_term_period'];      

            $data['name'] = $data['property_name'];
            $data['vieweing_option_id'] = $data['viewing_option_id'];
            $data['unit'] = $data['apt_number'];
            $data['latitude'] = $data['lat'];
            $data['longitude'] = $data['lng'];
            $data['monthly_rent'] = $data['yearly_price']/12;
            $data['total_price'] = $data['monthly_rent']+$data['security_deposit'];

            if(empty(Auth::user()->document) || (strtotime(Auth::user()->emirates_id_expiration_date) < strtotime(date("Y-m-d"))))
                $data['property_status_id'] = 2; //Property Will be pending inactive
            else
                $data['property_status_id'] = 6; //Property Will be inactive

            //$data['other_policies'] = '';

            if(array_key_exists('titledeed',$data) && !empty($data['titledeed'])){
                $user_id = Auth::user()->id;
                $title_deed_name = $user_id.'_'.time().'.'.$data['titledeed']->getClientOriginalExtension();            
                $dir = 'media/landlord/'.$user_id;
                if(is_dir($dir)){
                    $data['titledeed']->move($dir, $title_deed_name);
                }
                else{
                    mkdir($dir);
                    $data['titledeed']->move($dir, $title_deed_name);
                }
                $document_path = $dir.'/'.$title_deed_name;               
                $data['title_deed'] = $document_path;
            }
            /*echo '<pre>';
            print_r($data['old_images']);
            print_r($data['files']);
            die();*/
            $property->update($data);

            $new_amenities = $data['amenities']; 
            $old_amenities = explode(",",$request->input('old_amenities'));
           
            $remove_amenities=array_diff($old_amenities,$new_amenities);
            $add_amenities=array_diff($new_amenities,$old_amenities);
            
            AmenityProperty::whereIn('id', $remove_amenities)->delete(); 
            
            foreach ($add_amenities as $key => $value) {
                $amenity_property = new AmenityProperty();
                $amenity_data['created_at'] = date("Y-m-d H:i:s");
                $amenity_data['updated_at'] = date("Y-m-d H:i:s");
                $amenity_data['amenity_id'] = $value;
                $amenity_data['property_id'] = $id;

                //Inserting into amenity_property table, auto-updating Amenity property_count table
                $amenity_property->fill($amenity_data);
                $amenity_property->save($amenity_data);
            }

            if(isset($data['terms_condition']) && !empty($data['terms_condition'])){
                $new_terms_condition = $data['terms_condition']; 
                $old_terms_condition = explode(",",$request->input('old_terms_condition'));
               
                $remove_terms_condition=array_diff($old_terms_condition,$new_terms_condition);
                $add_terms_condition=array_diff($new_terms_condition,$old_terms_condition);
                
                PropertyTerm::whereIn('term_id', $remove_terms_condition)->delete(); 
                
                foreach ($add_terms_condition as $key => $value) {
                    $property_term = new PropertyTerm();
                    $term_data['term_id'] = $value;
                    $term_data['property_id'] = $id;

                    //Inserting into amenity_property table, auto-updating Amenity property_count table
                    $property_term->fill($term_data);
                    $property_term->save($term_data);
                }
            }
            
            
            //setting data for media table
            if(array_key_exists('files',$data)){
    
                $images = $data['files'];
                
                $media_data['created_at'] = date("Y-m-d H:i:s");
                $media_data['updated_at'] = date("Y-m-d H:i:s");
                $media_data['model_id'] = env('PROPERTY', '');
                $media_data['parent_id'] = $id;

                foreach ($images as $key => $value) {
                    $imageName = 'Image_'.rand().'.'.$value->getClientOriginalExtension();
                    //$path = public_path('media/landlord/'.$property['landlord_id']);
                    
                    //$value->move($path, $imageName);

                    // $path = $media_data['path'] = 'media/landlord/'.$property['landlord_id'].'/'.$imageName;
                    // Image::make($value->getRealPath())->resize(750, 450)->save($path);

                    $dir = 'media/landlord/'.$property['landlord_id'].'/'.$id;
                    $path = 'media/landlord/'.$property['landlord_id'].'/'.$id.'/'.$imageName;
                    if(is_dir($dir)){
                        Image::make($value->getRealPath())->resize(750, 450)->save($path);    
                    }
                    else{
                        mkdir($dir);
                        Image::make($value->getRealPath())->resize(750, 450)->save($path);    
                    }
                    $media_data['path'] = 'media/landlord/'.$property['landlord_id'].'/'.$id.'/'.$imageName;
                    DB::table('medias')->insert($media_data);   
                }
            }
            Session::flash('Success','Property Updated Successfully');
            return redirect('properties/manage');
        } catch (Exception $exception) {
            return redirect()->back()->withInput()
                         ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request!']);
        }

    }

    public function deleteImage($id)
    {  
        $media_id = $id;
        $media_detail = Media::findOrFail($media_id);
        $path = public_path($media_detail->path);
        unlink($path);
        $image =  Media::find($media_id)->delete();

    }

    /**
     * Display a listing of the properties.
     *
     * @return Illuminate\View\View
     */
    public function listing($search_bedroom_size_id=null, $search_property_type_id=null, $search_emirates_id=null)
    {  
        $bedroom_size_id = $washroom_size_id = $property_type = $emirates_id = $min_price = $max_price =  $price_sort_by = $search_min_price = $search_max_price = '';

        $available_sort_by = 2;

        $zoom_level = 0 ;
        $keyword = $address = '';

        $lat = 25.0709248;
        $lng = 55.1379023;

        if(isset($search_bedroom_size_id) || isset($search_property_type_id) || isset($search_emirates_id))
        {
           $zoom_level = 10;    
        }
        if(isset($search_bedroom_size_id) && !empty($search_bedroom_size_id)){
            $bedroom_size_id = $search_bedroom_size_id;
        }
        if(isset($search_property_type_id) && !empty($search_property_type_id)){
            $property_type_id = $search_property_type_id;
        }
        if(isset($search_emirates_id) && !empty($search_emirates_id)){
            $emirates_id = $search_emirates_id;

            if($emirates_id==1){
                $lat = env('ABU_DHABI_LAT');
                $lng = env('ABU_DHABI_LNG');
            }
            elseif($emirates_id==2){
                $lat = env('AJMAN_LAT');
                $lng = env('AJMAN_LNG');
            }
            elseif($emirates_id==3){
                $lat = env('DUBAI_LAT');
                $lng = env('DUBAI_LNG');
            }
            elseif($emirates_id==4){
                $lat = env('FUJAIRAH_LAT');
                $lng = env('FUJAIRAH_LNG');
            }
            elseif($emirates_id==5){
                $lat = env('RAS_AL_KHAIMAH_LAT');
                $lng = env('RAS_AL_KHAIMAH_LNG');
            }
            elseif($emirates_id==6){
                $lat = env('SHARJAH_LAT');
                $lng = env('SHARJAH_LNG');
            }
            elseif($emirates_id==7){
                $lat = env('QUWAIN_LAT');
                $lng = env('QUWAIN_LNG');
            }

        }
        if(isset($_REQUEST['keyword']) && !empty($_REQUEST['keyword']))
        $keyword = $address = $_REQUEST['keyword'];

        if(isset($_REQUEST['lat']) && !empty($_REQUEST['lat']))
            $lat = $_REQUEST['lat'];

        if(isset($_REQUEST['lng']) && !empty($_REQUEST['lng']))
            $lng = $_REQUEST['lng'];        

        if(isset($_REQUEST['search'])){
            $bedroom_size_id = (isset($_REQUEST['bedrooms'])) ? $_REQUEST['bedrooms'] : '';
            $washroom_size_id = (isset($_REQUEST['bathrooms'])) ? $_REQUEST['bathrooms'] : '';
            $property_type_id = (isset($_REQUEST['category'])) ? $_REQUEST['category'] : '';
            $emirates_id = (isset($_REQUEST['emirates'])) ? $_REQUEST['emirates'] : '';
            if($emirates_id==1){
                $lat = env('ABU_DHABI_LAT');
                $lng = env('ABU_DHABI_LNG');
            }
            elseif($emirates_id==2){
                $lat = env('AJMAN_LAT');
                $lng = env('AJMAN_LNG');
            }
            elseif($emirates_id==3){
                $lat = env('DUBAI_LAT');
                $lng = env('DUBAI_LNG');
            }
            elseif($emirates_id==4){
                $lat = env('FUJAIRAH_LAT');
                $lng = env('FUJAIRAH_LNG');
            }
            elseif($emirates_id==5){
                $lat = env('RAS_AL_KHAIMAH_LAT');
                $lng = env('RAS_AL_KHAIMAH_LNG');
            }
            elseif($emirates_id==6){
                $lat = env('SHARJAH_LAT');
                $lng = env('SHARJAH_LNG');
            }
            elseif($emirates_id==7){
                $lat = env('QUWAIN_LAT');
                $lng = env('QUWAIN_LNG');
            }

            $number_of_payments_id = (isset($_REQUEST['payments'])) ? $_REQUEST['payments'] : '';
            $amenities_id = (isset($_REQUEST['amenities'])) ? implode(',', $_REQUEST['amenities']):'';
            //$min_price = $_REQUEST['value-min'];
			//$max_price = $_REQUEST['value-max'];
			$search_min_price = (isset($_REQUEST['value-min']) && !empty($_REQUEST['value-min']))?str_replace(',', '', $_REQUEST['value-min']):'';
			$search_max_price = (isset($_REQUEST['value-max']) && !empty($_REQUEST['value-max']))?str_replace(',', '', $_REQUEST['value-max']):'';

            $available_sort_by = (isset($_REQUEST['available_sort_by'])) ? $_REQUEST['available_sort_by'] : '';
            $price_sort_by = (isset($_REQUEST['price_sort_by'])) ? $_REQUEST['price_sort_by'] : '';
        }

        $types = AppCode::PropertyType()->get()->toArray();
        $bedrooms = AppCode::BedroomSizes()->get()->toArray();
        $bathrooms = AppCode::WashroomSizes()->get()->toArray();
        $amenities = Amenity::get()->toArray();
        $emirates = AppCode::emirate()->get()->toArray();
        $payments = AppCode::numberofpayments()->get()->toArray();
      
        $prices = Property::selectRaw('MAX(yearly_price) as max_price')
                            ->selectRaw('MIN(yearly_price) as min_price')
                            ->get()
                            ->toArray();

        return view('properties.listing', compact('lat','lng','types','bedrooms','bathrooms','amenities','emirates','payments','keyword','prices','bedroom_size_id','washroom_size_id','property_type_id','emirates_id','amenities_id','number_of_payments_id','price_sort_by','available_sort_by','search_min_price','search_max_price','zoom_level'));

    }
	

    /**
     * Fetching data & converting php data array into json for displaying data on map 
     *
     * @return Illuminate\View\View
    */
	public function mapListing()
    {
        //values before point as to show all properties in the given location
    
        /*$lat = explode('.',$_GET['lat']);
        $lng = explode('.',$_GET['lng']); 
        
        $lt = "%".$lat[0]."%";
        $ln = "%".$lng[0]."%";*/

        $lat = $_GET['lat'];
        $lng = $_GET['lng'];
        $address = $category = $bedrooms = $bathrooms = $price = $amenities = $emirates = $number_of_payments_id = $available_sort_by = $price_sort_by = $search_min_price = $search_max_price = null;
   
        if(array_key_exists('category',$_GET)){
            $category = $_GET['category'];
        }
        if(array_key_exists('bedrooms',$_GET)){
            $bedrooms = $_GET['bedrooms'];
        }
        if(array_key_exists('bathrooms',$_GET)){
            $bathrooms = $_GET['bathrooms'];
        }
        if(array_key_exists('price',$_GET)){
            $price = $_GET['price'];
        }
        if(array_key_exists('amenities',$_GET)){
            $amenities = $_GET['amenities'];
        }
        if(array_key_exists('emirate',$_GET)){
            $emirates = $_GET['emirate'];
        }
        if(array_key_exists('payments',$_GET)){
            $number_of_payments_id = $_GET['payments'];
        }
        if(array_key_exists('address',$_GET)){
            $address = $_GET['address'];
        }
        if(array_key_exists('available_sort_by',$_GET)){
            $available_sort_by = $_GET['available_sort_by'];
        }
        if(array_key_exists('price_sort_by',$_GET)){
            $price_sort_by = $_GET['price_sort_by'];
        }
        if(array_key_exists('search_min_price',$_GET)){
            $search_min_price = $_GET['search_min_price'];
        }
        if(array_key_exists('search_max_price',$_GET)){
            $search_max_price = $_GET['search_max_price'];
        }
        $user_type = '';
        $user_id = '';
        if(!empty(Auth::user())) {
            $user_type = Auth::user()->user_type_id;
            $user_id = Auth::user()->id;
        }        

        //properties result on the basis of user login status
        $properties = Properties::instance()->getProperties($user_id,$user_type,$lat,$lng,$category,$bedrooms,$bathrooms,$price,$amenities,$emirates,$address,$number_of_payments_id,$available_sort_by, $price_sort_by, $search_min_price, $search_max_price);
       
        echo json_encode($properties); exit;
    }

    /**
     * Fetching data array for displaying data on sidebar of property-listing page 
     *
     * @return Illuminate\View\View
    */
    public function listingSidebar(Request $request)
    {
        $conditions = array();
        $user_id = '';
        $markers = (isset($request->markers))?$request->markers:array();
        if(!empty(Auth::user())){
            if(Auth::user()->user_type_id==env('USER_TYPE_LANDLORD')){
                $user_id = Auth::user()->id;
                $conditions = array('landlord_id'=>$user_id);
            }    
        }

        $available_sort_by = $request->available_sort_by;
        $price_sort_by = $request->price_sort_by;

        $data = [];
        $arr_data = array();
        $data = Property::with(
                array(
                    'PropertyStatus'=>function($query){
                        $query->select('id','name');
                    },
                    'Media'=>function($query){
                        $query->select('id','path','parent_id');
                    },
                    'BedroomSize'=>function($query){
                        $query->select('id','name');
                    },
                    'WashroomSize'=>function($query){
                        $query->select('id','name');
                    },
                    'User'=>function($query){
                        $query->select('id','firstname','lastname','profile_pic');
                    }
                )
            )
            ->when($available_sort_by==1, function ($query) use ($available_sort_by) {
                return $query->orderBy('available_from','ASC');
            })
            ->when($available_sort_by==2, function ($query) use ($available_sort_by) {
                return $query->orderBy('available_from','DESC');
            })
            ->when($price_sort_by==1, function ($query) use ($price_sort_by) {
                return $query->orderBy('yearly_price','ASC');
            })
            ->when($price_sort_by==2, function ($query) use ($price_sort_by) {
                return $query->orderBy('yearly_price','DESC');
            })
            ->where($conditions)
            ->where('bid_closure_date','>=',date("Y-m-d"))
            ->whereIn('id',$markers)
            ->get()
            ->toArray();
    
        
        return view('properties.listing-sidebar', compact('data','markers'));
    }

    public function infobox(Request $request)
    {
        $id = $request->id;
        $data = [];
        $property = Property::with(
                array(
                    'Media'=>function($query){
                        $query->select('id','path','parent_id');
                    },
                    'BedroomSize'=>function($query){
                        $query->select('id','name');
                    },
                    'WashroomSize'=>function($query){
                        $query->select('id','name');
                    },
                )
            )
            ->findOrFail($id)
            ->toArray();
        
        $gallery = array();
        foreach($property['media'] as $image){
            array_push($gallery, url('/').'/'.($image['path']));
        }
		$image_url = (isset($property['media'][0]['path']) && !empty($property['media'][0]['path']))?url('/').'/'.$property['media'][0]['path']:url('/').'/images/default.jpg';
        $data = [
            'id' => $property['id'],
            'latitude' => $property['latitude'],
            'longitude' => $property['longitude'],
            'name' => $property['name'],
            'address' => $property['address'],
            'monthly_rent' => $property['monthly_rent'],
            'bedrooms' => $property['bedroom_size']['name'],
            'washrooms' => $property['washroom_size']['name'],
            'area' => $property['area'],
            'gallery' => $image_url,
            'url' => url('/')."/properties/detail/".base64_encode($property['id']),
        ];
        return view('properties.infobox', compact('data','id'));
    }

    /**
     * Store a new property in the storage.
     *
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        try {
            //Creating object of Property Model
            $property = new Property;
            $data = $this->getData($request); //Validating request data      
            if($data['property_term_id'] == 1)
                $data['property_term_period'] = $data['short_property_term_period'];
            else
                $data['property_term_period'] = $data['long_property_term_period'];      
            $data['name'] = $data['property_name'];
            $data['vieweing_option_id'] = $data['viewing_option_id'];
            $data['unit'] = $data['apt_number'];
            $data['latitude'] = $data['lat'];
            $data['longitude'] = $data['lng'];
            $data['monthly_rent'] = $data['yearly_price']/12;
            $data['total_price'] = $data['monthly_rent']+$data['security_deposit'];
            if(empty(Auth::user()->document) || (strtotime(Auth::user()->emirates_id_expiration_date) < strtotime(date("Y-m-d"))))
                $data['property_status_id'] = 2; //Property Will be inactive
            else
                $data['property_status_id'] = 6; //Property Will be approval pending 

            $data['other_policies'] = '';
            $data['bid_count'] = 0;
            $user_id = $data['landlord_id'];

            $title_deed_name = $user_id.'_'.time().'.'.$data['titledeed']->getClientOriginalExtension();            
            $dir = 'media/landlord/'.$user_id;
            if(is_dir($dir)){
                $data['titledeed']->move($dir, $title_deed_name);
            }
            else{
                mkdir($dir);
                $data['titledeed']->move($dir, $title_deed_name);
            }
            $document_path = $dir.'/'.$title_deed_name;               
            $data['title_deed'] = $document_path;

            //Saving new property into properties table
            $property->fill($data);
            $property->save($data);

            $property_id = $property->id; //Last inserted id

            $prefix = env('PROPERTY_REFERENCE_PREFIX');
            $number = str_pad($property_id, 6, "0", STR_PAD_LEFT);
            $reference_number = $prefix.date("y").$number;

            DB::table('properties')
                        ->where('id', $property_id)
                        ->update(['reference_number' => $reference_number]);

            if(!empty($data['amenities'])){
                $amenities = $data['amenities'];
                foreach ($amenities as $key => $value) {
                    $amenity_property = new AmenityProperty();
                    $amenity_data['created_at'] = date("Y-m-d H:i:s");
                    $amenity_data['updated_at'] = date("Y-m-d H:i:s");
                    $amenity_data['amenity_id'] = $value;
                    $amenity_data['property_id'] = $property_id;

                    //Inserting into amenity_property table, auto-updating Amenity property_count table
                    $amenity_property->fill($amenity_data);
                    $amenity_property->save($amenity_data);
                }
            }

            if(!empty($data['terms_condition'])){
                $terms_conditions = $data['terms_condition'];

                foreach ($terms_conditions as $key => $value) {
                    $property_term = new PropertyTerm();
                    $property_data['created_at'] = date("Y-m-d H:i:s");
                    $property_data['updated_at'] = date("Y-m-d H:i:s");
                    $property_data['term_id'] = $value;
                    $property_data['property_id'] = $property_id;

                    //Inserting into amenity_property table, auto-updating Amenity property_count table
                    $property_term->fill($property_data);
                    $property_term->save($property_data);
                }
            }
            



            //setting data for media table
            if(!empty($data['files'])){
                $images = $data['files'];

                $media_data['created_at'] = date("Y-m-d H:i:s");
                $media_data['updated_at'] = date("Y-m-d H:i:s");
                $media_data['model_id'] = env('PROPERTY', '');
                $media_data['parent_id'] = $property_id;

                foreach ($images as $key => $value) {
                    $imageName = 'Image_'.rand().'.'.$value->getClientOriginalExtension();
                    //$path = public_path('media/landlord/'.$user_id);
                    //$value->move($path, $imageName);
                    $dir = 'media/landlord/'.$user_id.'/'.$property_id;
                    $path = 'media/landlord/'.$user_id.'/'.$property_id.'/'.$imageName;
                    if(is_dir($dir)){
                        Image::make($value->getRealPath())->resize(750, 450)->save($path);    
                    }
                    else{
                        mkdir($dir);
                        Image::make($value->getRealPath())->resize(750, 450)->save($path);    
                    }
                    

                    $media_data['path'] = 'media/landlord/'.$user_id.'/'.$property_id.'/'.$imageName;
                    DB::table('medias')->insert($media_data);   
                }
            }

            $mail_result = $this->add_property(Auth::user()->firstname, Auth::user()->lastname, Auth::user()->email, $data['name']);
            
            $admin_email = $this->admin_property_notify_mail($data['name']);        
            
            if(empty(Auth::user()->document))
                Session::flash('Success','Your property is in queue, you have to submit your emirates id/passport for getting it approved');
            else
                Session::flash('Success','Your property has been added & sent for the approval');
            //return redirect('/properties/listing#survey');
            return redirect('/properties/manage');
        } catch (Exception $exception) {
            return redirect()->back()->withInput()
                         ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request!']);
        }
    }

    /**
     * Display the specified property.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function detail($id)
    {
        $property_id = $id = base64_decode($id);
        $property = Property::with(
                array(
                    'PropertyStatus'=>function($query){
                        $query->select('id','name');
                    },
                    'Media'=>function($query){
                        $query->select('id','path','parent_id');
                    },
                    'Emirate'=>function($query){
                        $query->select('id','name');
                    },
                    'PropertyType'=>function($query){
                        $query->select('id','name');
                    },
                    'VieweingOption'=>function($query){
                        $query->select('id','name');
                    },
                    'BedroomSize'=>function($query){
                        $query->select('id','name');
                    },
                    'WashroomSize'=>function($query){
                        $query->select('id','name');
                    },
                    'noOfPayments'=>function($query){
                        $query->select('id','name');
                    },
                    'User'=>function($query){
                        $query->select('id','firstname','lastname','profile_pic','mobile','country_code','document','passport');
                    },
                    'AmenityProperty'=>function($query){
                        $query->select('id','amenity_id','property_id');
                    },
                    'PropertyTerm'=>function($query){
                        $query->select('id','term_id','property_id');
                    },
                    'Bidding'=>function($query){
                        $query->select('id','tenant_id');
                    },
                )
            )
            ->findOrFail($id);

        //update view_count for property
        $oldCount = $property->view_count;
        $ip = $_SERVER['REMOTE_ADDR'];
        if(empty(Auth::user())){
            $view_count_detail = PropertyView::where('property_id', $property_id)
                                            ->where('ip_address', $ip)
                                            ->where('user_id',NULL)
                                            ->first();
            if(empty($view_count_detail)){
                $view_data['property_id'] = $property_id;
                $view_data['ip_address'] = $ip;


                $view_count_obj = new PropertyView;
                $view_count_obj->fill($view_data);
                $view_count_obj->save();

                $updateCount = $property->update(['view_count'=> $oldCount+1]);
            }
        }
        else{
            $user_id = (!empty(Auth::user())) ? Auth::user()->id : '';
            $query1 = PropertyView::where('property_id', $property_id)
                                    ->where('user_id', $user_id)
                                    ->first();
            if(empty($query1)){
                $view_data['property_id'] = $property_id;
                $view_data['ip_address'] = $ip;
                $view_data['user_id'] = $user_id;

                $view_count_obj = new PropertyView;
                $view_count_obj->fill($view_data);
                $view_count_obj->save();

                $updateCount = $property->update(['view_count'=> $oldCount+1]);
            }
        }
        
        /*$oldCount = $property->view_count;
        $updateCount = $property->update(['view_count'=>$oldCount+1]);*/

    
        $property = $property->toArray();
        $user_id = (!empty(Auth::user())) ? Auth::user()->id : '';
        
        //Array of properties against which the logged in Tenant has already made a bid
        $tenant_bid_property = Bidding::select('id','tenant_id','property_id')->where('tenant_id',$user_id)->get()->toArray();

        $maxBidPrice = Bidding::selectRaw('MAX(propose_rent) as maximum_bid_price')->where('property_id',$property['id'])->first()->toArray();
        
        $amenities = Amenity::where('amenity_status_id',1)->pluck('name','id')->all();
        $amenities_icon = Amenity::where('amenity_status_id',1)->pluck('icon_class','id')->all();

        $employment_status = AppCode::employmentstatus()->orderBy('sort_order')->pluck('name','id')->all();
		$terms_conditions = AppCode::termsCondition()->orderBy('sort_order')->pluck('name','id')->all();
        
        return view('properties.property-detail', compact('property','amenities','employment_status','tenant_bid_property','amenities_icon','terms_conditions','maxBidPrice'));
    }

    /**
     * Manage all property.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function manageProperties()
    {
        $landlord_id = Auth::user()->id;

        $all_properties = Property::with('PropertyStatus:id,name')
                                    ->select('properties.*')
                                    ->join('property_statuses', 'property_statuses.id', '=', 'properties.property_status_id')
                                    ->orderBy('property_statuses.sort_order', 'ASC') 
                                    ->orderBy('properties.created_at','desc')
                                    ->where('landlord_id', $landlord_id)
                                    ->paginate(10,['*'], 'all');
        
        $live_properties = Property::where('landlord_id', $landlord_id)
            ->where('property_status_id', 1)
            ->orderBy('created_at','desc')
            ->paginate(10,['*'], 'live');

        $rented_properties = Property::where('landlord_id', $landlord_id)
            ->where('property_status_id', 5)
            ->orderBy('created_at','desc')
            ->paginate(10,['*'], 'rented');

        $expired_properties = Property::where('landlord_id', $landlord_id)
            ->where('property_status_id', 4)
            ->orderBy('created_at','desc')
            ->paginate(10,['*'], 'expired');

        $pending_properties = Property::with('PropertyStatus:id,name')->where('landlord_id', $landlord_id)
            ->where(function ($query) {
                    $query->where('property_status_id', 6)
                          ->orWhere('property_status_id', 2);
                })
            ->orderBy('created_at','desc')
            ->paginate(10,['*'], 'pending');
        
        if(Input::get('live')){
            $filter = 'live';
        }
        else if(Input::get('all')){
            $filter = 'all';
        }
        else if(Input::get('rented')){
            $filter = 'rented';
        }
        else if(Input::get('expired')){
            $filter = 'expired';
        }
        else if(Input::get('pending')){
            $filter = 'pending';
        }
        else{
            $filter = '';
        }

        return view('properties.manage-property', compact('live_properties','rented_properties','expired_properties','pending_properties','all_properties','filter'));
    }


    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request\Request $request 
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
            'property_name' => 'required|string|min:1|max:255|nullable',
            'address' => 'required|string|min:1|nullable',
            'apt_number' => 'required|string|min:1|nullable',
            'area' => 'required|string|min:1|nullable',
            'description' => 'required|string|min:1|max:1500|nullable',
            'lat' => 'required|string|min:1|nullable',
            'lng' => 'required|string|min:1|nullable',
            'yearly_price' => 'required|string|min:1|nullable',
            'security_deposit' => 'required|string|min:1|nullable',
            'total_price' => 'numeric|nullable',
            'other_policies' => 'string|min:1|nullable',
            'available_from' => 'required|date|nullable',
            'emirate_id' => 'required|nullable',
            'property_type_id' => 'required|nullable',
            'viewing_option_id' => 'required|nullable',
            'bedroom_size_id' => 'required|nullable',
            'washroom_size_id' => 'required|nullable',
            'landlord_id' => 'nullable',
            'bid_count' => 'numeric|nullable',
            'property_status_id' => 'nullable',
            'amenities' => 'required|nullable',
            'files'=>'nullable',
            'property_term_id' => 'required|nullable',
            'bid_closure_date' => 'required|nullable',
            'number_of_payments_id' => 'required|nullable',
            'titledeed' => 'nullable|mimes:pdf,doc,docx|max:2048',
            'terms_condition' => 'nullable',
            'old_images' => 'nullable',
            'short_property_term_period' => 'nullable',
            'long_property_term_period' => 'nullable'
        ];
        $data = $request->validate($rules);
        return $data;
    }

    public function survey(Request $request)
    {
        $survey = new Survey();
        $survey->user_id = Auth::user()->id;
        $survey->parent_id = Session::get('survey_parent');
        $survey->model_id = env('PROPERTY');
        $survey->result = $request->surveyvalue;
        $survey->save();

        session()->forget('survey_parent');
        Session::flash('Success','Thank You for your feedback. Have a great day! :)');
        return redirect('/properties/listing');
    }


    # All admin actions for properties with be in below section 

    /**
     * Display the list of all properties.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function adminProperties()
    {
        $landlord_id = 0;
        $property_status_id = 0;
        $property_id = 0;
        $start_date = '';
        $end_date = '';


        //Cache::forget('user');
        /* Caching query */
        $landlords = Cache::remember('user', env('CACHE_TIME'), function()
        {
            return User::select('id','firstname','lastname','email')->where('user_type_id',env('USER_TYPE_LANDLORD'))->orderBy('firstname')->get()->toArray();
        });
        
        $property_status = Cache::remember('property_status', env('CACHE_TIME'), function()
        {
            return PropertyStatus::select('id','name')->get()->toArray();
        });
        /* Cache ends here */

        $conditions = array();

        if($_SERVER['REQUEST_METHOD']=='POST'){            
            $landlord_id = (isset($_POST['landlord_id'])) ? $_POST['landlord_id']:0;
            $property_status_id = (isset($_POST['property_status_id'])) ? $_POST['property_status_id']:0; 
            $property_id = (isset($_POST['property_id'])) ? $_POST['property_id']:0; 
            $start_date = (!empty($_POST['start_date'])) ? date("Y-m-d", strtotime($_POST['start_date'])) : '';
            $end_date = (!empty($_POST['end_date'])) ? date("Y-m-d", strtotime($_POST['end_date'])) : '';
        }
        /* Getting filter parameters for pagination */
        if(isset($_GET['landlord_id']) && !empty($_GET['landlord_id']))
            $landlord_id = $_GET['landlord_id'];
        if(isset($_GET['property_status_id']) && !empty($_GET['property_status_id']))
            $property_status_id = $_GET['property_status_id'];
        if(isset($_GET['start_date']) && !empty($_GET['start_date']))
            $start_date = date("Y-m-d", strtotime($_GET['start_date']));
        if(isset($_GET['end_date']) && !empty($_GET['end_date']))
            $end_date = date("Y-m-d", strtotime($_GET['end_date']));
        /* Ends Here */
        
        $all_properties = Property::Select('id','name','reference_number')->get()->toArray();        

        $properties = Property::with(
                array(
                    'Bidding'=>function($query){
                        $query->select('id','property_id')
                              ->where('bid_status_id',48);
                    },
                    'PropertyStatus'=>function($query){
                        $query->select('id','name');
                    },
                    'noOfPayments'=>function($query){
                        $query->select('id','name');
                    },
                    'User'=>function($query){
                        $query->select('id','firstname','lastname','profile_pic');
                    },
                )
            )
            // ->orderBy('property_status_id','ASC')
            // ->orderBy('name','ASC')
            ->when($landlord_id, function ($query) use ($landlord_id) {
                return $query->where('landlord_id',$landlord_id);
            })
            ->when($property_id, function ($query) use ($property_id) {
                return $query->where('id',$property_id);
            })
            ->when($property_status_id, function ($query) use ($property_status_id) {
                return $query->where('property_status_id',$property_status_id);
            })
            ->when($start_date, function ($query) use ($start_date,$end_date) {
                return $query->whereBetween('created_at',[date("Y-m-d", strtotime($start_date)),date("Y-m-d", strtotime($end_date."+1 day"))]);
            })
            ->sortable(['property_status_id'=>'ASC', 'name' => 'ASC'])
            ->paginate(10);
        return view('admin.property-list', compact('properties','landlords','property_status','landlord_id','property_status_id','start_date','end_date','property_id','all_properties'));
    }

    /**
     * Getting particular property
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function adminPropertiesForm($property_id)
    {
        $properties = Property::with(
                array(
                    'PropertyStatus'=>function($query){
                        $query->select('id','name');
                    },
                    'Media'=>function($query){
                        $query->select('id','path','parent_id');
                    },
                    'Emirate'=>function($query){
                        $query->select('id','name');
                    },
                    'PropertyType'=>function($query){
                        $query->select('id','name');
                    },
                    'VieweingOption'=>function($query){
                        $query->select('id','name');
                    },
                    'BedroomSize'=>function($query){
                        $query->select('id','name');
                    },
                    'WashroomSize'=>function($query){
                        $query->select('id','name');
                    },
                    'User'=>function($query){
                        $query->select('id','firstname','lastname','profile_pic');
                    },
                    'AmenityProperty'=>function($query){
                        $query->select('id','amenity_id','property_id');
                    },
                    'Bidding'=>function($query){
                        $query->select('id','tenant_id');
                    },
                )
            )
            ->findOrFail($property_id)
            ->toArray();
        //Return reponse object to prevent controller from trying to render a view
        return response()->json($properties);
    }

    /**
     * Exporting Properties to Excel
     *
     * @param 
     *
     * @return Illuminate\View\View
     */
    public function adminExportProperties($landlord_id,$property_status_id,$start_date=null,$end_date=null)
    {
        $conditions = array();

        if(!empty($start_date))
            $start_date = date("Y-m-d", strtotime($start_date));
        if(!empty($end_date))
            $end_date = date("Y-m-d", strtotime($end_date));

        $properties = Property::with(
                array(
                    'PropertyStatus'=>function($query){
                        $query->select('id','name');
                    },
                    'Emirate'=>function($query){
                        $query->select('id','name');
                    },
                    'PropertyType'=>function($query){
                        $query->select('id','name');
                    },
                    'VieweingOption'=>function($query){
                        $query->select('id','name');
                    },
                    'BedroomSize'=>function($query){
                        $query->select('id','name');
                    },
                    'WashroomSize'=>function($query){
                        $query->select('id','name');
                    },
                    'noOfPayments'=>function($query){
                        $query->select('id','name');
                    },
                    'User'=>function($query){
                        $query->select('id','firstname','lastname','profile_pic','mobile','email','address','city');
                    },
                    'AmenityProperty'=>function($query){
                        $query->select('id','amenity_id','property_id');
                    },
                    'Bidding'=>function($query){
                        $query->select('id','tenant_id');
                    },
                )
            )
            ->orderBy('name')
            ->when($landlord_id, function ($query) use ($landlord_id) {
                return $query->where('landlord_id',$landlord_id);
            })
            ->when($property_status_id, function ($query) use ($property_status_id) {
                return $query->where('property_status_id',$property_status_id);
            })
            ->when($start_date, function ($query) use ($start_date,$end_date) {
                return $query->whereBetween('created_at',[date("Y-m-d", strtotime($start_date)),date("Y-m-d", strtotime($end_date."+1 day"))]);
            })
            ->get()
            ->toArray();   
        Excel::create('PropertiesReport', function($excel) use ($properties){
            $excel->sheet('property', function($sheet) use ($properties){                
                $sheet->row(1,array('Property ID', 'Property Name','Added On','Address','Apt/Villa No','Area(Sq Ft)','Description','Yearly Price','Monthly Rent','Security Deposit','Total Price','Available From','Emirate','Property Type','Viewing Option','Bedrooms','Washrooms','Landlord','Mobile Number','Email','Address','City','Bid Count','View Count', 'Property Status','Bid Selected','Number of Payments' ));
                //$sheet->fromArray($properties);
                $i=2;
                foreach($properties as $property){
                    $bid_selected = ($property['bid_selected']==1) ? 'Yes' : 'No';
                    $sheet->row($i, array($property['id'], $property['name'], $property['created_at'], $property['address'], $property['unit'], $property['area'], $property['description'],number_format($property['yearly_price'],2), number_format($property['monthly_rent'],2), number_format($property['security_deposit'],2), number_format($property['total_price'],2), $property['available_from'], $property['emirate']['name'], $property['property_type']['name'], $property['vieweing_option']['name'], $property['bedroom_size']['name'], $property['washroom_size']['name'], $property['user']['firstname'].' '.$property['user']['lastname'], $property['user']['mobile'], $property['user']['email'], $property['user']['address'], $property['user']['city'], $property['bid_count'], $property['view_count'], $property['property_status']['name'], $bid_selected,$property['no_of_payments']['name']));
                    $i++;
                }
            });
        })->export('xls');
        die();
    }







}