<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Page;

class PagesController extends Controller
{
    
    /**
     * Terms & Condition Page content
     *
     * @return \Illuminate\Http\Response
     */
    public function terms()
    {
        $terms_content = Page::where('url_key','terms')
        						->get()
        						->first()
        						->toArray();
      	
        return view('terms', compact('terms_content'));
    }

    /**
     * Privacy Policy Page content
     *
     * @return \Illuminate\Http\Response
     */
    public function privacy()
    {
        $privacy_content = Page::where('url_key','privacy')
                                ->get()
                                ->first()
                                ->toArray();
        
        return view('privacy', compact('privacy_content'));
    }

}
