<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Notification;
use App\Models\User;
use Cache;
use Excel;
class NotificationsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function adminMessages()
    {
        $user_id = 0;
        $start_date = '';
        $end_date = '';
        $message_type = '';

        if($_SERVER['REQUEST_METHOD']=='POST'){            
            $user_id = $_POST['user_id'];
            $start_date = (!empty($_POST['start_date'])) ? date("Y-m-d", strtotime($_POST['start_date'])) : '';
            $end_date = (!empty($_POST['end_date'])) ? date("Y-m-d", strtotime($_POST['end_date'])) : '';
            $message_type = (!empty($_POST['message_type_id'])) ? $_POST['message_type_id'] : '';
        }
        /* Getting filter parameters for pagination */
        if(isset($_GET['user_id']) && !empty($_GET['user_id']))
            $user_id = $_GET['user_id'];
        if(isset($_GET['start_date']) && !empty($_GET['start_date']))
            $start_date = date("Y-m-d", strtotime($_GET['start_date']));
        if(isset($_GET['end_date']) && !empty($_GET['end_date']))
            $end_date = date("Y-m-d", strtotime($_GET['end_date']));
        /* Ends Here */

        $notifications = Notification::with('user:id,firstname,lastname')
                                    //->orderBy('created_at','desc')
                                    ->when($user_id, function ($query) use ($user_id) {
                                        return $query->where('notifiable_id',$user_id);
                                    })
                                    ->when($start_date, function ($query) use ($start_date,$end_date) {
                                        return $query->whereBetween('created_at',[date("Y-m-d", strtotime($start_date)),date("Y-m-d", strtotime($end_date."+1 day"))]);
                                    })
                                    ->when($message_type==1, function ($query){
                                        return $query->where('type_id',env('MESSAGE_TYPE_BID'));
                                    })
                                    ->when($message_type==2, function ($query){
                                        return $query->where('type_id',env('MESSAGE_TYPE_CONTRACT'));
                                    })
                                    ->when($message_type==3, function ($query){
                                        return $query->where('type_id',env('MESSAGE_TYPE_PROPERTY'));
                                    })
                                    ->sortable(['created_at'=>'desc'])
                                    ->paginate(10);

        $all_users = Cache::remember('all_users', env('CACHE_TIME'), function()
        {
            return User::select('id','firstname','lastname','email')->orderBy('firstname')->get()->toArray();
        });

        return view('admin.messages-list', compact('notifications','user_id','start_date','end_date','all_users','message_type'));
    }


    /**
     * Exporting Messages to Excel
     *
     * @param 
     *
     * @return Illuminate\View\View
     */
    public function adminExportMessages($user_id,$message_type=null,$start_date=null,$end_date=null)
    {
        $conditions = array();

        if(!empty($start_date))
            $start_date = date("Y-m-d", strtotime($start_date));
        if(!empty($end_date))
            $end_date = date("Y-m-d", strtotime($end_date));

        $notifications = Notification::with('user:id,firstname,lastname,email,mobile,country_code')
                                    ->orderBy('created_at','desc')
                                    ->when($user_id, function ($query) use ($user_id) {
                                        return $query->where('notifiable_id',$user_id);
                                    })
                                    ->when($start_date, function ($query) use ($start_date,$end_date) {
                                        return $query->whereBetween('created_at',[date("Y-m-d", strtotime($start_date)),date("Y-m-d", strtotime($end_date."+1 day"))]);
                                    })
                                    ->when($message_type==1, function ($query){
                                        return $query->where('type_id',env('MESSAGE_TYPE_BID'));
                                    })
                                    ->when($message_type==2, function ($query){
                                        return $query->where('type_id',env('MESSAGE_TYPE_CONTRACT'));
                                    })
                                    ->when($message_type==3, function ($query){
                                        return $query->where('type_id',env('MESSAGE_TYPE_PROPERTY'));
                                    })
                                    ->get()
                                    ->toArray();
            
        Excel::create('MessagesReport', function($excel) use ($notifications){
            $excel->sheet('messages', function($sheet) use ($notifications){                
                $sheet->row(1,array('User Name','Email','Contact Number','Message','Date-Time','Type'));
                $i=2;
                foreach($notifications as $notification){

                    $data = json_decode($notification['data'], true);
                    if($notification['type_id'] == env('MESSAGE_TYPE_BID'))
                        $type = 'Bid';
                    elseif($notification['type_id'] == env('MESSAGE_TYPE_CONTRACT'))
                        $type = 'Contract';
                    elseif($notification['type_id'] == env('MESSAGE_TYPE_PROPERTY'))
                        $type = 'Property';
                    else
                        $type = 'Unknown';

                    $sheet->row($i, array($notification['user']['firstname'].' '.$notification['user']['lastname'],$notification['user']['email'],$notification['user']['country_code'].'-'.$notification['user']['mobile'], $data['message'],  $notification['created_at'],$type));
                    $i++;
                }
            });
        })->export('xls');
        die();
    }

}
