<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Mail;

use App\Http\Requests;
use App\Http\Controllers\Controller;

class MailsController extends Controller {
    /*public function admin_property_notify_mail($property_name){
      	$data = array('email'=>env('ADMIN_EMAIL'));   
        $msg = 'A new property '.$property_name.' has been submitted for approval. Please visit Bid2Rent';
	      Mail::send(['text'=>$msg], $data, function($message) {
	         $message->to($data['email'], 'Bid2Rent')->subject
	            ('New Property Approval Request');
	         $message->from(env('MAIL_USERNAME'),'Bid2Rent');
	      });
    }*/

   public function html_email($first_name, $last_name, $email, $new_password){
    $data = array('first_name'=>$first_name, 'last_name'=>$last_name,'email'=>$email, 'password' =>$new_password);
    Mail::send('mail', $data, function($message) use ($data) {
        $message->to($data['email'], 'Bid2Rent')->subject
            ('Reset Password');
        $message->from(env('MAIL_USERNAME'),'Bid2Rent');
    });
   }

   public function add_property($first_name, $last_name, $email, $property_name){
    $data = array('first_name'=>$first_name, 'last_name'=>$last_name,'email'=>$email, 'property_name' =>$property_name);
    Mail::send('addProperty', $data, function($message) use ($data) {
        $message->to($data['email'], 'Bid2Rent')->subject
            ('Property');
        $message->from(env('MAIL_USERNAME'),'Bid2Rent');
    });
   }

   public function bid_submit($landlord_name, $landlord_email, $tenant_name, $property_name){
    $data = array('landlord_name'=>$landlord_name, 'landlord_email'=>$landlord_email,'tenant_name'=>$tenant_name, 'property_name' =>$property_name);
    Mail::send('bidSubmit', $data, function($message) use ($data) {
        $message->to($data['landlord_email'], 'Bid2Rent')->subject
            ('New Bid');
        $message->from(env('MAIL_USERNAME'),'Bid2Rent');
    });
   }

   public function bid_reject($tenant_email, $tenant_name, $property_name){
    $data = array('tenant_email'=>$tenant_email,'tenant_name'=>$tenant_name, 'property_name' =>$property_name);
    Mail::send('bidRetire', $data, function($message) use ($data) {
        $message->to($data['tenant_email'], 'Bid2Rent')->subject
            ('Bid Rejected');
        $message->from(env('MAIL_USERNAME'),'Bid2Rent');
    });
   }

   public function bid_select($first_name, $last_name, $email, $property_name){
    $data = array('tenant_email'=>$email,'tenant_name'=>$first_name.' '.$last_name, 'property_name'=>$property_name);
    Mail::send('bidSelect', $data, function($message) use ($data) {
        $message->to($data['tenant_email'], 'Bid2Rent')->subject
            ('Bid Selected');
        $message->from(env('MAIL_USERNAME'),'Bid2Rent');
    });
   }

   public function send_otp($username, $email, $otp){
    $data = array('email'=>$email,'name'=>$username, 'otp'=>$otp);
    Mail::send('otpMail', $data, function($message) use ($data) {
        $message->to($data['email'], 'Bid2Rent')->subject
            ('Registration');
        $message->from(env('MAIL_USERNAME'),'Bid2Rent');
    });
   }

    public function property_status($username, $email, $status, $property_name){
      $data = array('email'=>$email,'landlord_name'=>$username, 'property_name'=>$property_name, 'status'=>$status);
      Mail::send('propertyStatus', $data, function($message) use ($data) {
          $message->to($data['email'], 'Bid2Rent')->subject
              ('Bid Selected');
          $message->from(env('MAIL_USERNAME'),'Bid2Rent');
      });
     }

     public function admin_property_notify_mail($property_name){
        $data = array('email'=>env('ADMIN_EMAIL'), 'property_name'=>$property_name);
        Mail::send('adminPropertyNotify', $data, function($message) use ($data) {
            $message->to($data['email'], 'Bid2Rent')->subject
                ('New Property Submitted');
            $message->from(env('MAIL_USERNAME'),'Bid2Rent');
        });
    }

    public function contact_us($fullname, $msg){
        $data = array('email'=>env('ADMIN_EMAIL'), 'fullname'=>$fullname, 'msg' => $msg);
        Mail::send('adminContactUs', $data, function($message) use ($data) {
            $message->to($data['email'], 'Bid2Rent')->subject
                ('Contact Us');
            $message->from(env('MAIL_USERNAME'),'Bid2Rent');
        });
    }

    public function contract_upload($tenant_name, $email, $property_name){
    $data = array('tenant_email'=>$email,'tenant_name'=>$tenant_name, 'property_name'=>$property_name);
    Mail::send('contractUpload', $data, function($message) use ($data) {
        $message->to($data['tenant_email'], 'Bid2Rent')->subject
            ('Tenancy Contract Upload');
        $message->from(env('MAIL_USERNAME'),'Bid2Rent');
    });
   }

   public function tenant_approve_contract($landlord_name, $email, $property_name){
    $data = array('landlord_email'=>$email,'landlord_name'=>$landlord_name, 'property_name'=>$property_name);
    Mail::send('tenantApproveContract', $data, function($message) use ($data) {
        $message->to($data['landlord_email'], 'Bid2Rent')->subject
            ('Tenancy Contract Approved');
        $message->from(env('MAIL_USERNAME'),'Bid2Rent');
    });
   }

   /*public function attachment_email(){
      $data = array('name'=>"Virat Gandhi");
      Mail::send('mail', $data, function($message) {
         $message->to('abc@gmail.com', 'Tutorials Point')->subject
            ('Laravel Testing Mail with Attachment');
         $message->attach('C:\laravel-master\laravel\public\uploads\image.png');
         $message->attach('C:\laravel-master\laravel\public\uploads\test.txt');
         $message->from('xyz@gmail.com','Virat Gandhi');
      });
      echo "Email Sent with attachment. Check your inbox.";
   }*/
}
?>