<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use App\Models\ContactQuery;
use Session;

class ContactQueriesController extends MailsController
{
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{
            $data = $this->getData($request); //Validating request data            
            $data['fullname'] = $data['contactusname'];
            $data['email'] = $data['contactusemailaddress'];
            $data['country_code'] = $data['country_code_2'];
            $data['mobile'] = $data['mobile2'];
            $data['message'] = $data['contactusmessage'];
            $contact_us = new ContactQuery;
            $contact_us->fill($data);
            $contact_us->save();

            /* Notifying admin by email about query */
            $mail_result = $this->contact_us($data['fullname'], $data['message']);

            Session::flash('Success','Your query has been submitted successfully');

            return redirect()->back();
        }
        catch(Exception $exception){
            return back()->withInput()
                         ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request!']);
        }
        
    }
    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request\Request $request 
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
            'contactusname' => 'string|required',
            'contactusemailaddress' => 'required|email|nullable',
            'country_code_2' =>'required|nullable',
            'mobile2' =>'required|nullable',
            'contactusmessage' =>'required|nullable',
        ];
        $data = $request->validate($rules);
        return $data;
    }
    

    /**
     * Admin Contact Queries List Section
     * 
     * @return Illuminate\View\View
     */
    public function adminQueryList()
    {
        $start_date = '';
        $end_date = '';

        if($_SERVER['REQUEST_METHOD']=='POST'){                        
            $start_date = (!empty($_POST['start_date'])) ? date("Y-m-d", strtotime($_POST['start_date'])) : '';
            $end_date = (!empty($_POST['end_date'])) ? date("Y-m-d", strtotime($_POST['end_date'])) : '';
        }
        /* Getting filter parameters for pagination */        
        if(isset($_GET['start_date']) && !empty($_GET['start_date']))
            $start_date = date("Y-m-d", strtotime($_GET['start_date']));
        if(isset($_GET['end_date']) && !empty($_GET['end_date']))
            $end_date = date("Y-m-d", strtotime($_GET['end_date']));
        /* Ends Here */

        $results = ContactQuery::orderBy('id','desc')
                        ->when($start_date, function ($query) use ($start_date,$end_date) {
                            return $query->whereBetween('created_at',[date("Y-m-d", strtotime($start_date)),date("Y-m-d", strtotime($end_date."+1 day"))]);
                        })
                        ->paginate(10);

        return view('/admin/contact-us',compact('results', 'start_date','end_date'));
    }


    
}
