<?php

namespace App\Http\Controllers;
use Google_Client; 
use Google_Service_Drive;
use Google_Service_AnalyticsReporting;
use Google_Service_AnalyticsReporting_DateRange;
use Google_Service_AnalyticsReporting_Metric;
use Google_Service_AnalyticsReporting_Dimension;
use Google_Service_AnalyticsReporting_DimensionFilter;
use Google_Service_AnalyticsReporting_DimensionFilterClause;
use Google_Service_AnalyticsReporting_ReportRequest;
use Google_Service_AnalyticsReporting_GetReportsRequest;
class AnalyticsController extends Controller
{
    /**
     * Display a listing of the successfully commission paid bids.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $_SERVER['DOCUMENT_ROOT']. '/bid2rent/vendor/autoload.php';
        $analytics = $this->initializeAnalytics();
        $response = $this->getReport($analytics);
        $this->printResults($response);
    }
 

    /**
     * Initializes an Analytics Reporting API V4 service object.
     *
     * @return An authorized Analytics Reporting API V4 service object.
     */
    function initializeAnalytics()
    {

      // Use the developers console and download your service account
      // credentials in JSON format. Place them in this directory or
      // change the key file location if necessary.
      $KEY_FILE_LOCATION = __DIR__ . '/service-account-credentials.json';

      // Create and configure a new client object.
      $client = new Google_Client();
      $client->setApplicationName("Hello Analytics Reporting");
      $client->setAuthConfig($KEY_FILE_LOCATION);
      $client->setScopes(['https://www.googleapis.com/auth/analytics.readonly']);
      $analytics = new Google_Service_AnalyticsReporting($client);

      return $analytics;
    }


    /**
     * Queries the Analytics Reporting API V4.
     *
     * @param service An authorized Analytics Reporting API V4 service object.
     * @return The Analytics Reporting API V4 response.
     */
    function getReport($analytics) {

      // Replace with your view ID, for example XXXX.
      $VIEW_ID = "169298745";

      // Create the DateRange object.
      $dateRange = new Google_Service_AnalyticsReporting_DateRange();
      $dateRange->setStartDate("7daysAgo");
      $dateRange->setEndDate("yesterday");

      // Create the Metrics object.
      $pageview_count = new Google_Service_AnalyticsReporting_Metric();
      $pageview_count->setExpression("ga:pageviews");
      $pageview_count->setAlias("pageviewcount");

      //Create the browser dimension.
      $browser = new Google_Service_AnalyticsReporting_Dimension();
      $browser->setName("ga:pagePath");
      
      // Create Dimension Filter.
      $dimensionFilter = new Google_Service_AnalyticsReporting_DimensionFilter();
      $dimensionFilter->setDimensionName("ga:pagePath");
      $dimensionFilter->setOperator("EXACT");
      $dimensionFilter->setExpressions(array("/bid2rent/public/"));

      // Create the DimensionFilterClauses
      $dimensionFilterClause = new Google_Service_AnalyticsReporting_DimensionFilterClause();
      $dimensionFilterClause->setFilters(array($dimensionFilter));

      // Create the ReportRequest object.
      $request = new Google_Service_AnalyticsReporting_ReportRequest();
      $request->setViewId($VIEW_ID);
      $request->setDateRanges($dateRange);
      $request->setMetrics(array($pageview_count));
      $request->setDimensions(array($browser  ));
      $request->setDimensionFilterClauses(array($dimensionFilterClause));  

      $body = new Google_Service_AnalyticsReporting_GetReportsRequest();
      $body->setReportRequests( array( $request) );
      return $analytics->reports->batchGet( $body );
    }


    /**
     * Parses and prints the Analytics Reporting API V4 response.
     *
     * @param An Analytics Reporting API V4 response.
     */
    function printResults($reports) {        
        for ( $reportIndex = 0; $reportIndex < count( $reports ); $reportIndex++ ) {
            $report = $reports[ $reportIndex ];
            $header = $report->getColumnHeader();
            $dimensionHeaders = $header->getDimensions();
            $metricHeaders = $header->getMetricHeader()->getMetricHeaderEntries();
            $rows = $report->getData()->getRows();

            for ( $rowIndex = 0; $rowIndex < count($rows); $rowIndex++) {
              $row = $rows[ $rowIndex ];
              $dimensions = $row->getDimensions();
              $metrics = $row->getMetrics();
              /*for ($i = 0; $i < count($dimensionHeaders) && $i < count($dimensions); $i++) {
                print($dimensionHeaders[$i] . ": " . $dimensions[$i] . "\n");
              }*/

              for ($j = 0; $j < count($metrics); $j++) {
                $values = $metrics[$j]->getValues();
                for ($k = 0; $k < count($values); $k++) {
                  $entry = $metricHeaders[$k];
                  return $values[$k];
                  //print($entry->getName() . ": " . $values[$k] . "\n");                  
                }
              }
            }
        }
    }
}
