<?php
namespace App\Http\Controllers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use DB;
use Session;
use Excel;
use Cache;
use App\Models\User;
use App\Models\SmsReport;
use Mail;
use App\Models\Property;
use App\Models\AppCode;
use App\Models\PropertyStatus;
use App\Models\Bidding;
use App\Models\Survey;
use App\Models\UserType;
use App\Models\Transaction;
use App\Models\Amenity;
use Auth;
use DateTime;
use DateInterval;
use DatePeriod;
use Redirect;
class AdminController extends AnalyticsController
{
	/**
     * Admin Login Section
     *
     * @param  Request  $request
     * @return Response
     */
	    public function login(Request $request){
			
	    	$email = $request->input('email');
	    	$password = $request->input('password');
			$user_detail = User::where(['email'=>$email, 'user_type_id'=>1])->first();
			if($user_detail){
				$hashed_password = Hash::check($password, $user_detail->password);
				if($hashed_password){
					Auth::login($user_detail);
					return redirect('/admin/dashboard');
				}
				else{
					Session::flash('Error', 'Invalid Email or Password !'); 
					return redirect('/administrator');
				}
			}	    
	    	else{
		    	Session::flash('Error', 'Invalid Email or Password !'); 
	    		return redirect('/administrator');
		   	}
	    	
	    }

    /**
     * Get Change Password View
     *
     * @param  $id
     * @return Response
     */ 
    public function changePassword()
    {
        $id = Auth::user()->id;
        $userInfo = User::where('id',$id)->get()->toArray();
        return view('admin.change-password',compact('userInfo'));
    }

    /**
     * Update Password
     *
     * @param  Request $request
     * @param  $id
     * @return Response
     */ 
    public function updatePassword(Request $request)
    {
        $id = Auth::user()->id;
        $oldPass = $request->input('oldPassword');
        $newPass = $request->input('newPassword');
        $confirmPass = $request->input('confirmPassword');

        $request->validate(['oldPassword'=>'required',
        'newPassword'=>'required|min:8|regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d).+$/',
        'confirmPassword'=>'required|same:newPassword']);
        
        $user = User::where('id',$id)->select('firstname','lastname','email','password')->first();
        $hashed_password = Hash::check($oldPass, $user->password);

        $firstname = $user->firstname;
        $lastname = $user->lastname;   
        if($hashed_password)
        {
            if($newPass === $confirmPass)
            {
                $new_password = Hash::make($newPass); //Encrypting password
                if(DB::table('users')
                ->where('id', $id)
                ->update(['password' => $new_password, 'updated_at' => date("Y-m-d H:i:s")]))
                {
                    DB::table('user_logins')
                    ->where('user_id',Auth::user()->id)
                    ->update(['logout_time' => date("Y-m-d H:i:s"), 'updated_at' => date("Y-m-d H:i:s")]);
                    Session::flush();
                    Session::flash('Success', 'Your Password has been updated.Please login again.'); 
                    return redirect('/administrator');
                }
                else{
                    Session::flash('Error', 'Something went wrong !'); 
                }   
            }
            else{
                Session::flash('Error', 'New Password and Confirm Password does not match!');
            }

        }   
        else
        {
            Session::flash('Error', 'Old Password Does Not Match!');
        }      
        return Redirect::route('adminChangePassword',[Auth::user()->id]);
    }


	/**
     * Admin Dashbopard Section
     *
     * @return Illuminate\View\View
     */
		public function dashboard()
		{	
			
			$total = Property::count();
			$activeProperty = PropertyStatus::where('name','Active')->select('name','property_count')->pluck('property_count','name')->toArray();
			$completedProperty = PropertyStatus::where('name','Closed')->select('name','property_count')->pluck('property_count','name')->toArray();
            $approvalPendingProperty = Property::selectRaw('count(id) as count')->where('property_status_id',6)->get()->toArray();

			$statusCount =  DB::table('biddings')
									->selectRaw('count(*) as status_count, bid_status_id')
									->groupBy('bid_status_id')
									->pluck('status_count','bid_status_id')
									->toArray();
			$totalBidCount = 0;
			if($statusCount){
				foreach($statusCount as $totalBid){
					$totalBidCount = $totalBidCount + $totalBid;
					
				}
			}
			
			$received_payment = Transaction::selectRaw('sum(amount) as amount')
										->where('payment_status_id',3)
										->get()
										->toArray();

			/* Users Data for graphical representation */
			$users_data = User::with('UserType:id,name')
                        ->selectRaw('count(id) as user_count, user_type_id')
                        ->groupBy('user_type_id')
                        ->get()
                        ->toArray();
                        
            /*last 7 days properties graphical representation */
            $end_date = date("Y-m-d"); //Current date will be the end date
            $start_date = date("Y-m-d", strtotime("-7 days"));

            $properties_weekly = Property::selectRaw('count(id) as property_count')
            								->selectRaw(DB::raw('DATE(created_at) as created_at'))
            								->whereBetween('created_at',[$start_date, date("Y-m-d", strtotime($end_date."+1 day"))])
            								->groupBy(DB::raw('DATE(created_at)'))
            								->get()
            								->toArray();

            /* last 30 days properties graphical representation */
            $end_date = date("Y-m-d"); //Current date will be the end date
            $start_date = date("Y-m-d", strtotime("-30 days"));

            $properties_monthly = Property::selectRaw('count(id) as property_count')
            								->selectRaw(DB::raw('DATE(created_at) as created_at'))
            								->whereBetween('created_at',[$start_date, date("Y-m-d", strtotime($end_date."+1 day"))])
            								->groupBy(DB::raw('DATE(created_at)'))
            								->get()
            								->toArray();
         	
         	/*last 7 days bids graphical representation */
            $end_date = date("Y-m-d"); //Current date will be the end date
            $start_date = date("Y-m-d", strtotime("-7 days"));

            $bids_weekly = Bidding::selectRaw('count(id) as bid_count')
            								->selectRaw(DB::raw('DATE(created_at) as created_at'))
            								->whereBetween('created_at',[$start_date, date("Y-m-d", strtotime($end_date."+1 day"))])
            								->groupBy(DB::raw('DATE(created_at)'))
            								->get()
            								->toArray();

         	/* Array of last 7 days */
         	$weekly_date_arr = array();
            $end_date = date("Y-m-d"); //Current date will be the end date
            $start_date = date("Y-m-d", strtotime("-6 days"));

            $begin = new DateTime($start_date);
            $end = new DateTime($end_date);
            $end = $end->modify( '+1 day' ); 

            $interval = new DateInterval('P1D');
            $daterange = new DatePeriod($begin, $interval ,$end);
            foreach($daterange as $date){
                array_push($weekly_date_arr, $date->format("Y-m-d H:i:s"));                          
            }
            /* Ends Here */


            /* Array of last 30 days */
            $monthly_date_arr = array();
         	$end_date = date("Y-m-d"); //Current date will be the end date
            $start_date = date("Y-m-d", strtotime("-30 days"));

            $begin = new DateTime($start_date);
            $end = new DateTime($end_date);
            $end = $end->modify( '+1 day' ); 

            $interval = new DateInterval('P1D');
            $daterange = new DatePeriod($begin, $interval ,$end);
            foreach($daterange as $date){
                array_push($monthly_date_arr, $date->format("Y-m-d H:i:s"));
            }                          
            /* Ends Here */

            /* Google Analytics for Home page count of last 7 days */
            $_SERVER['DOCUMENT_ROOT']. '/bid2rent/vendor/autoload.php';
            $analytics = AnalyticsController::initializeAnalytics();
            $response = AnalyticsController::getReport($analytics);
            $home_count = AnalyticsController::printResults($response);
            /* Google Analytics Ends Here */


			return view('/admin/dashboard',compact('total','activeProperty','completedProperty','statusCount','totalBidCount','received_payment','users_data','properties_weekly','properties_monthly','bids_weekly','weekly_date_arr','monthly_date_arr','home_count','approvalPendingProperty'));
	    }

	/**
     * Admin Users List Section
	 * 
     * @return Illuminate\View\View
     */
	public function users()
	{
		$user_id = 0;
		$status = '';
		$user_type_id = 0;
		$start_date = '';
		$end_date = '';

		$conditions = array();
        if($_SERVER['REQUEST_METHOD']=='POST'){            
            $user_id = $_POST['user_id'];
            $status = $_POST['user_status'];
            $user_type_id = $_POST['user_type'];
            $start_date = (!empty($_POST['start_date'])) ? date("Y-m-d", strtotime($_POST['start_date'])) : '';
            $end_date = (!empty($_POST['end_date'])) ? date("Y-m-d", strtotime($_POST['end_date'])) : '';
        }
        /* Getting filter parameters for pagination */
        if(isset($_GET['user_id']) && !empty($_GET['user_id']))
        	$user_id = $_GET['user_id'];
        if(isset($_GET['status']) && is_numeric($_GET['status']))
        	$status = $_GET['status'];
        if(isset($_GET['user_type_id']) && !empty($_GET['user_type_id']))
        	$user_type_id = $_GET['user_type_id'];
        if(isset($_GET['start_date']) && !empty($_GET['start_date']))
        	$start_date = date("Y-m-d", strtotime($_GET['start_date']));
        if(isset($_GET['end_date']) && !empty($_GET['end_date']))
        	$end_date = date("Y-m-d", strtotime($_GET['end_date']));
        /* Ends Here */
        
        $user_types = UserType::pluck('name','id')->all();

        //$all_users = User::select('id','firstname','lastname','email')->orderBy('firstname')->get()->toArray();
        $all_users = Cache::remember('all_users', env('CACHE_TIME'), function()
        {
            return User::select('id','firstname','lastname','email')->orderBy('firstname')->get()->toArray();
        });


		$users = User::when($user_id, function ($query) use ($user_id) {
                            return $query->where('id',$user_id);
                        })
						->when(is_numeric($status), function ($query) use ($status) {
                            return $query->where('status',$status);
                        })
                        ->when($user_type_id, function ($query) use ($user_type_id) {
                            return $query->where('user_type_id',$user_type_id);
                        })
                        ->when($start_date, function ($query) use ($start_date,$end_date) {
                            return $query->whereBetween('created_at',[date("Y-m-d", strtotime($start_date)),date("Y-m-d", strtotime($end_date."+1 day"))]);
                        })
                        ->sortable(['id'=>'DESC'])
						->paginate(10);

		return view('/admin/users',compact('users','user_id','status','user_types','user_type_id','all_users','start_date','end_date'));
	}
	

	/**
     * Exporting Users to Excel
     *
     * @param 
     *
     * @return Illuminate\View\View
     */
    public function adminExportUsers($user_id,$user_type_id,$start_date=null,$end_date=null,$status=null)
    {
        $conditions = array();

        if(!empty($start_date))
        	$start_date = date("Y-m-d", strtotime($start_date));
        if(!empty($end_date))
        	$end_date = date("Y-m-d", strtotime($end_date));

        $users = User::with('UserType:id,name')
        				->orderBy('firstname')
        				->when($user_id, function ($query) use ($user_id) {
                            return $query->where('id',$user_id);
                        })
						->when($status, function ($query) use ($status) {
                            return $query->where('status',$status);
                        })
                        ->when($user_type_id, function ($query) use ($user_type_id) {
                            return $query->where('user_type_id',$user_type_id);
                        })
                        ->when($start_date, function ($query) use ($start_date,$end_date) {
                           return $query->whereBetween('created_at',[date("Y-m-d", strtotime($start_date)),date("Y-m-d", strtotime($end_date."+1 day"))]);
                        })
                        ->get()
                        ->toArray();
            
        Excel::create('UsersReport', function($excel) use ($users){
            $excel->sheet('property', function($sheet) use ($users){                
                $sheet->row(1,array('User Id','First Name','Last Name','Email','Contact Number','Contact Verified','Address','City','User Type','Status','DOB','Short Bio','Added On','Emirates ID Expiration Date'));
                $i=2;
                foreach($users as $user){
                    $mobile_verified = ($user['is_mobile_verified']==1) ? 'Yes' : 'No';
                    $status = ($user['status']==1) ? 'Active' : 'Inactive';
                    $sheet->row($i, array($user['id'],$user['firstname'],$user['lastname'],$user['email'],$user['country_code'].'-'.$user['mobile'], $mobile_verified, $user['address'], $user['city'], $user['user_type']['name'], $status, $user['dob'], $user['short_bio'],$user['created_at'], date("j F, Y", strtotime($user['emirates_id_expiration_date']))));
                    $i++;
                }
            });
        })->export('xls');
        die();
    }


	/**
     * Update User
     *
     * @param  Request  $request
     * @return Response
     */
	public function editUser(Request $request)
	{
		$request->validate(['firstname'=>'required',
		'lastname'=>'required',
		'address'=> 'required',
		'city'=> 'required',
		'mobile'=> 'required',
		'status'=> 'required'
		]);
		$user = User::where('id',$request->user_id)->first();
		
		$updated_at = date("Y-m-d H:i:s");

		$user->update(['firstname'=>$request->input('firstname'),
						'lastname'=>$request->input('lastname'),
						'address'=>$request->input('address'),
						'city'=>$request->input('city'),
						'user_type_id'=>$request->input('user_type'),
						'status'=>$request->input('status'),
						'updated_at'=>$updated_at
					]);

		if(($user->mobile != $request->mobile) || ($user->is_mobile_verified == 0) )
		{  
			$otp = rand(100000, 999999);	
			$user->update(['mobile'=>$request->mobile,'is_mobile_verified'=>0,'otp'=>$otp,'updated_at'=>$updated_at]);
		}

		$data = array('first_name'=>$request->firstname, 'last_name'=>$request->lastname,'email'=>$user->email);
		Mail::send('updateMail', $data, function($message) use ($data) {
			$message->to($data['email'], 'Bid2Rent')->subject
				('Profile Updated');
			$message->from(env('MAIL_USERNAME'),'Bid2Rent');
		});
		Session::flash('Success','User with ID "'.$request->user_id.'" Updated Successfully.');
		return redirect('/admin/users');
	}

    /**
     * Update property
     *
     * @param  Request  $request
     * @return Response
     */
    public function editPropertyStatus(Request $request)
    {
        $property_id = $request->edit_property_id;
        if(isset($property_id) && !empty($property_id)){
            $status = $request->edit_property_status;
            $property = Property::with('User','PropertyStatus')->where('id',$property_id)->first();
            $property->update(['property_status_id'=>$status]);

            $email = $property->user->email;
            $username = $property->user->firstname.' '.$property->user->lastname;
            $status = $property->propertystatus->name;
            $property_name = $property->name;

            $mail_obj = new MailsController;
            $mail_obj->property_status($username, $email, $status, $property_name);
            Session::flash('Success','Property Status updated successfully');
        }
        else{
            Session::flash('Error','Something went wrong !');        
        }
        return redirect()->back();
    }


    /**
     * Display the specified property.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function propertyDetail($id)
    {
        $property_id = $id = base64_decode($id);
        $property = Property::with(
                array(
                    'PropertyStatus'=>function($query){
                        $query->select('id','name');
                    },
                    'Media'=>function($query){
                        $query->select('id','path','parent_id');
                    },
                    'Emirate'=>function($query){
                        $query->select('id','name');
                    },
                    'PropertyType'=>function($query){
                        $query->select('id','name');
                    },
                    'VieweingOption'=>function($query){
                        $query->select('id','name');
                    },
                    'BedroomSize'=>function($query){
                        $query->select('id','name');
                    },
                    'WashroomSize'=>function($query){
                        $query->select('id','name');
                    },
                    'noOfPayments'=>function($query){
                        $query->select('id','name');
                    },
                    'User'=>function($query){
                        $query->select('id','firstname','lastname','profile_pic','mobile','country_code');
                    },
                    'AmenityProperty'=>function($query){
                        $query->select('id','amenity_id','property_id');
                    },
                    'PropertyTerm'=>function($query){
                        $query->select('id','term_id','property_id');
                    },
                    'Bidding'=>function($query){
                        $query->select('id','tenant_id');
                    },
                )
            )
            ->findOrFail($id);
    
        $property = $property->toArray();
        
        $amenities = Amenity::where('amenity_status_id',1)->pluck('name','id')->all();
        $amenities_icon = Amenity::where('amenity_status_id',1)->pluck('icon_class','id')->all();
        $terms_conditions = AppCode::termsCondition()->orderBy('sort_order')->pluck('name','id')->all();

        return view('admin.admin-property-detail', compact('property','amenities','amenities_icon','terms_conditions'));
    }

	/**
     * Admin Surveys List Section
     *
     * @return Illuminate\View\View
     */
	public function surveys()
	{
        $user_id = 0;
        $start_date = '';
        $end_date = '';

        if($_SERVER['REQUEST_METHOD']=='POST'){            
            $user_id = $_POST['user_id'];
            $start_date = (!empty($_POST['start_date'])) ? date("Y-m-d", strtotime($_POST['start_date'])) : '';
            $end_date = (!empty($_POST['end_date'])) ? date("Y-m-d", strtotime($_POST['end_date'])) : '';
        }
        /* Getting filter parameters for pagination */
        if(isset($_GET['user_id']) && !empty($_GET['user_id']))
            $user_id = $_GET['user_id'];
        if(isset($_GET['start_date']) && !empty($_GET['start_date']))
            $start_date = date("Y-m-d", strtotime($_GET['start_date']));
        if(isset($_GET['end_date']) && !empty($_GET['end_date']))
            $end_date = date("Y-m-d", strtotime($_GET['end_date']));
        /* Ends Here */

        $all_users = Cache::remember('all_users', env('CACHE_TIME'), function()
        {
            return User::select('id','firstname','lastname','email')->orderBy('firstname')->get()->toArray();
        });

		$surveys = Survey::with('user')
                            ->when($user_id, function ($query) use ($user_id) {
                                return $query->where('user_id',$user_id);
                            })
                            ->when($start_date, function ($query) use ($start_date,$end_date) {
                                return $query->whereBetween('created_at',[date("Y-m-d", strtotime($start_date)),date("Y-m-d", strtotime($end_date."+1 day"))]);
                            })
                            //->orderBy('id','desc')
                            ->sortable(['id'=>'desc'])
                            ->paginate(10);

		return view('/admin/surveys',compact('surveys','user_id','start_date','end_date','all_users'));
	}


     /**
     * Exporting Surveys to Excel
     *
     * @param 
     *
     * @return Illuminate\View\View
     */
    public function adminExportSurveys($user_id,$start_date=null,$end_date=null)
    {
        $conditions = array();

        if(!empty($start_date))
            $start_date = date("Y-m-d", strtotime($start_date));
        if(!empty($end_date))
            $end_date = date("Y-m-d", strtotime($end_date));

        $surveys = Survey::with('user')
                            ->when($user_id, function ($query) use ($user_id) {
                                return $query->where('user_id',$user_id);
                            })
                            ->when($start_date, function ($query) use ($start_date,$end_date) {
                                return $query->whereBetween('created_at',[date("Y-m-d", strtotime($start_date)),date("Y-m-d", strtotime($end_date."+1 day"))]);
                            })
                            ->orderBy('id','desc')
                            ->get()
                            ->toArray();
            
        Excel::create('SurveysReport', function($excel) use ($surveys){
            $excel->sheet('surveys', function($sheet) use ($surveys){                
                $sheet->row(1,array('User Name','Response','Date'));
                $i=2;
                foreach($surveys as $survey){
                    $sheet->row($i, array($survey['user']['firstname'].' '.$survey['user']['lastname'], $survey['result'], date("j F, Y", strtotime($survey['created_at']))));
                    $i++;
                }
            });
        })->export('xls');
        die();
    }


	/**
     * Admin Logout Section
     *
     * @param  Request  $request
     * @return Response
     */
	public function logout(){
		Session::flush();
		Session::flash('Success','Successfully Logged Out');
		return redirect('/administrator');	
		Auth::logout();
	}


    /**
     * Function that view tenancy contract form
     *
     * @param 
     *
     * @return \Illuminate\Http\Response
     */
    public function viewAdminContract( $bid_id = null)
    {
        if(isset($bid_id)){
            $bid_id = base64_decode($bid_id);

            $bidding_detail = Bidding::where('id', $bid_id)
                    ->with(array(
                        'TenancyContract',
                        'Property'=>function($query){
                            $query->with('PropertyTerm:id,term_id,property_id');
                        },
                    ))
                    ->first()
                    ->toArray();
                    
            $terms_conditions = AppCode::termsCondition()->orderBy('sort_order')->pluck('name','id')->all();
        } else{
            Session::flash('Error','Unauthorised access !');            
            return redirect('/');
        }
        return view('contracts/view-contract-form', compact('bidding_detail','terms_conditions'));
    }

}
