<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Bidding;
use App\Models\Transaction;
use Mail;

class TenancyRenewalCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:TenancyRenewal';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send reminder for property renewal';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
		$log_file = storage_path('logs/RenewalReminderCronJobLogs-'.date("d-m-Y").'.log'); 
		$this->write_log($log_file, date('d-m-Y H:i:s').' : Cron Method Triggered');
		$this->write_log($log_file, ' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
        //$current_date = '2018-12-21';

        /* Notification sending to tenant script */
        $current_date = date("Y-m-d");            
        $biddings_detail = Bidding::Select('id','tenancy_contract_end_date','tenant_id')->with('property:id,name','tenant:id,firstname,lastname,email')->where('tenancy_contract_end_date','=',date('Y-m-d', strtotime("+2 months +15 days", strtotime($current_date))))->get()->toArray();
        $this->write_log($log_file, date('d-m-Y H:i:s').' : Tenant Notification'); 
        $this->write_log($log_file, ' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');

        if(sizeof($biddings_detail)){            
            foreach($biddings_detail as $bid){
                $this->write_log($log_file, date('d-m-Y H:i:s').' : Email Notification will send to User ID ----> '.$bid['tenant_id']);
                /*
                    SENDING EMAIL NOTIFICATION 
                */        
                $data = array('tenant_name'=>$bid['tenant']['firstname'].' '.$bid['tenant']['lastname'], 'tenant_email'=>$bid['tenant']['email'], 'property_name' =>$bid['property']['name']);        
                Mail::send('tenancyContractRenewalNotification', $data, function($message) use ($data) {
                    $message->to($data['tenant_email'], 'Bid2Rent')->subject
                        ('Tenancy Contract Renewal');
                    $message->from(env('MAIL_USERNAME'),'Bid2Rent');
                });

                $this->write_log($log_file, date('d-m-Y H:i:s').' : Email Notification has been sent to User ID ----> '.$bid['tenant_id']);
                $this->write_log($log_file, ' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
            }
        }
        else{
            $this->write_log($log_file, date('d-m-Y H:i:s').' : No record found'); 
            $this->write_log($log_file, ' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
        } 
        /* Ends here */

        /* Notification sending to landlord*/
        $current_date = date("Y-m-d");            
        $biddings_detail = Bidding::with(array('Property'=>function($query){
                                        $query->with('Landlord:id,firstname,lastname,email,address,country_code,mobile');
                                    }))
                                    ->where('tenancy_contract_end_date','=',date('Y-m-d', strtotime("+1 month", strtotime($current_date))))->get()->toArray();

        $this->write_log($log_file, date('d-m-Y H:i:s').' : Landlord Notification'); 
        $this->write_log($log_file, ' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
        if(sizeof($biddings_detail)){
            foreach($biddings_detail as $bid){
                $this->write_log($log_file, date('d-m-Y H:i:s').' : Email Notification will send to User ID ----> '.$bid['property']['landlord_id']);
                /*
                    SENDING EMAIL NOTIFICATION 
                */        
                $data = array('landlord_name'=>$bid['property']['landlord']['firstname'].' '.$bid['property']['landlord']['lastname'], 'landlord_email'=>$bid['property']['landlord']['email'], 'property_name' =>$bid['property']['name']);        
                Mail::send('tenancyContractLandlordNotification', $data, function($message) use ($data) {
                    $message->to($data['landlord_email'], 'Bid2Rent')->subject
                        ('Tenancy Contract Renewal');
                    $message->from(env('MAIL_USERNAME'),'Bid2Rent');
                });

                $this->write_log($log_file, date('d-m-Y H:i:s').' : Email Notification has been sent to User ID ----> '.$bid['property']['landlord_id']);
                $this->write_log($log_file, ' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
            }
        }
        else{
            $this->write_log($log_file, date('d-m-Y H:i:s').' : No record found'); 
            $this->write_log($log_file, ' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
        } 
        /* Ends Here */
    }

    function write_log($log_file, $content) {
        if(!file_exists($log_file)) {
            $fp = fopen($log_file,"w");
        }
        else {
            $fp = fopen($log_file,"r+");
        }
        $content = trim(file_get_contents($log_file))."\n".$content;

        if(fwrite($fp,$content)){
            fclose($fp);
        }
    }
}
