<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Property;
use Mail;
class PropertyExpireCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:PropertyExpire';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Make all properties expired if their bid_closure_date passed and bid_count is 0';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $properties = Property::with('landlord:id,firstname,lastname,email')
                            ->where('bid_closure_date','<',date("Y-m-d"))
                            ->where('bid_count',0)
                            ->get()
                            ->toArray();
                            
        $log_file = storage_path('logs/'.date("d-m-Y").'_PropertyExpireCronJobLogs'); 

        if(count($properties)){
            $this->write_log($log_file, date('d-m-Y H:i:s').' : Total no. of Properties found ----> '.sizeof($properties));
            $this->write_log($log_file, ' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');

            foreach($properties as $property){
                echo 'Status Updated for Property ID '. $property['id'];
                
                $property_detail = Property::where('id',$property['id'])->first();
                $property_detail->update(['property_status_id'=>4]);

                $this->write_log($log_file, date('d-m-Y H:i:s').' : Property Status Expired for the Property ID ----> '.$property['id']);

                $data = array('landlord_name'=>$property['landlord']['firstname'].' '.$property['landlord']['lastname'], 'landlord_email'=>$property['landlord']['email'], 'property_name' =>$property['name']);
                                   
                Mail::send('propertyExpire', $data, function($message) use ($data) {
                    $message->to($data['landlord_email'], 'Bid2Rent')->subject
                        ('Property Expire');
                    $message->from(env('MAIL_USERNAME'),'Bid2Rent');
                });
            }    
            $this->write_log($log_file, ' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
        }
        else{
            echo 'No record found';
            $this->write_log($log_file, date('d-m-Y H:i:s').' : Total no. of Properties found ----> '.sizeof($properties));
            $this->write_log($log_file, date('d-m-Y H:i:s').' No record found to update');
            $this->write_log($log_file, ' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
        }
    }

    function write_log($log_file, $content) {
        if(!file_exists($log_file)) {
            $fp = fopen($log_file,"w");
        }
        else {
            $fp = fopen($log_file,"r+");
        }
        $content = trim(file_get_contents($log_file))."\n".$content;

        if(fwrite($fp,$content)){
            fclose($fp);
        }
    }

}
