<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Bidding;
use App\Models\Transaction;
use Mail;
use DB;
class BidStatusCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:BidStatus';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Make all bids retired, if not confirm in two days';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $biddings = Bidding::with('transaction','tenant','property')
                            ->where('bid_status_id',48)
                            ->orWhere('bid_status_id',50)
                            ->get()
                            ->toArray();
        $log_file = storage_path('logs/'.date("d-m-Y").'_CronJobLogs'); 

        if(count($biddings)){
            $this->write_log($log_file, date('d-m-Y H:i:s').' : Total no. of Bids found ----> '.sizeof($biddings));
            $this->write_log($log_file, ' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');

            foreach($biddings as $bid){
                $bid_selection_time = $bid['bid_selection_time'];
                $bid_confirm_expire_time = date("Y-m-d H:i:s", strtotime(env('CONFIG_OPT_OUT_TIME'), strtotime($bid_selection_time)));
                $current_time = date("Y-m-d H:i:s");
                if(strtotime($current_time) > strtotime($bid_confirm_expire_time)){

                    $bid_id = $bid['id'];                    

                    $bid_status_id = $bid['bid_status_id'];
                    $property_id = $bid['property_id'];

                    DB::table('properties')
                        ->where('id', $property_id)
                        ->update(['bid_selected' =>0]);

                    $this->write_log($log_file, date('d-m-Y H:i:s').' : Bid Status Expired for the Bid ID ----> '.$bid_id);

                    $data = array('tenant_name'=>$bid['tenant']['firstname'].' '.$bid['tenant']['lastname'], 'tenant_email'=>$bid['tenant']['email'], 'property_name' =>$bid['property']['name']);
                                       
                    Mail::send('bidRetire', $data, function($message) use ($data) {
                        $message->to($data['tenant_email'], 'Bid2Rent')->subject
                            ('Bid Retired');
                        $message->from(env('MAIL_USERNAME'),'Bid2Rent');
                    });

                    
                    $bidding_detail = Bidding::where('id',$bid_id)->first();
                    $bidding_detail->update(['bid_status_id'=>55]);
                    foreach($bid['transaction'] as $transaction){

                        $this->write_log($log_file, date('d-m-Y H:i:s').' : Transaction Status Expired for the Transaction ID ----> '.$transaction['id'] .' and Bid ID '.$bid_id);                        

                        $transaction_detail = Transaction::where('id',$transaction['id'])->first();
                        $transaction_detail->update(['payment_status_id'=>4]);    
                    }                    
                }
                else{
                    $this->write_log($log_file, date('d-m-Y H:i:s').'No record found to update'); 
                }
                
            }    
            $this->write_log($log_file, ' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
        }
        else{
            $this->write_log($log_file, date('d-m-Y H:i:s').' : Total no. of Bids found ----> '.sizeof($biddings));
            $this->write_log($log_file, date('d-m-Y H:i:s').' No record found to update');
            $this->write_log($log_file, ' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
        }
    }

    function write_log($log_file, $content) {
        if(!file_exists($log_file)) {
            $fp = fopen($log_file,"w");
        }
        else {
            $fp = fopen($log_file,"r+");
        }
        $content = trim(file_get_contents($log_file))."\n".$content;

        if(fwrite($fp,$content)){
            fclose($fp);
        }
    }
}
