<?php
namespace App\Component\Property;
use App\Models\Property;
use App\Models\Media;
use App\Models\AppCode;
use App\Models\Amenity;
use App\Models\AmenityProperty;
use DB;
class Properties
{
    public function getProperties($user_id,$user_type,$lat,$lng,$category,$bedrooms,$bathrooms,$price,$amenities,$emirates,$address,$payments, $available_sort_by, $price_sort_by, $search_min_price, $search_max_price)
    {   
        $amenities = explode(',', $amenities);
        $properties = Property::with('AmenityProperty')->select('properties.id','latitude','longitude','properties.address','properties.available_from',
                                   DB::raw("
                                    ( 6371 * acos( cos( radians(".$lat.") ) *
                                      cos( radians( latitude ) )
                                      * cos( radians( longitude ) - radians(".$lng.")
                                      ) + sin( radians(".$lat.") ) *
                                      sin( radians( latitude ) ) )
                                    ) AS distance" 
                                ))
                                ->where('property_status_id',1)
                                ->where('bid_closure_date','>=',date("Y-m-d"))
                                ->having("distance", "<", 50)
                                ->when($category, function ($query) use ($category) {
                                    return $query->where('property_type_id',$category);
                                })
                                ->when($bedrooms, function ($query) use ($bedrooms) {
                                    return $query->where('bedroom_size_id',$bedrooms);
                                })
                                ->when($bathrooms, function ($query) use ($bathrooms) {
                                    return $query->where('washroom_size_id',$bathrooms);
                                })
                                ->when($user_id, function ($query) use ($user_id, $user_type) {
                                    if($user_type == env('USER_TYPE_LANDLORD')){
                                        return  $query->where('landlord_id', $user_id);
                                    }
                                })
                                ->when($search_min_price, function ($query) use ($search_min_price, $search_max_price) {
                                    return $query->whereBetween('yearly_price',[$search_min_price,$search_max_price]);
                                })
                                ->when($emirates, function ($query) use ($emirates) {
                                    return $query->where('emirate_id',$emirates);
                                })
                                ->when($payments, function ($query) use ($payments) {
                                    return $query->where('number_of_payments_id',$payments);
                                })
                                ->when($available_sort_by==1, function ($query) use ($available_sort_by) {
                                    return $query->orderBy('available_from','ASC');
                                })
                                ->when($available_sort_by==2, function ($query) use ($available_sort_by) {
                                    return $query->orderBy('available_from','DESC');
                                })
                                ->when($price_sort_by==1, function ($query) use ($price_sort_by) {
                                    return $query->orderBy('yearly_price','ASC');
                                })
                                ->when($price_sort_by==2, function ($query) use ($price_sort_by) {
                                    return $query->orderBy('yearly_price','DESC');
                                })
                                /*->when($amenities, function ($query) use ($amenities) {
                                    // return Property::join('amenity_property','amenity_property.property_id','=','properties.id')
                                    //                 ->whereIn('amenity_id',$amenities);
                                    $query->whereIn('AmenityProperty.amenity_id', $amenities);
                                }) */                    
                                ->get()
                                ->toArray();
                      
        /*$properties = Property::join('users','properties.landlord_id','=','users.id')
                                ->select('properties.id','latitude','longitude','properties.address')
                                ->where('property_status_id',1)
                                // ->when($lt, function ($query) use ($lt) {
                                //     return $query->whereRaw('latitude like "'.$lt.'"');
                                // })
                                // ->when($ln, function ($query) use ($ln) {
                                //     return $query->whereRaw('longitude like "'.$ln.'"');
                                // })
                                ->when($category, function ($query) use ($category) {
                                    return $query->where('property_type_id',$category);
                                })
                                ->when($bedrooms, function ($query) use ($bedrooms) {
                                    return $query->where('bedroom_size_id',$bedrooms);
                                })
                                ->when($bathrooms, function ($query) use ($bathrooms) {
                                    return $query->where('washroom_size_id',$bathrooms);
                                })
                                ->when($price, function ($query) use ($price) {
                                    return $query->whereBetween('monthly_rent',[$price[0],$price[1]]);
                                })
                                ->when($amenities, function ($query) use ($amenities) {
                                    return Property::join('amenity_property','amenity_property.property_id','=','properties.id')
                                                    ->whereIn('amenity_id',$amenities);
                                })
                                ->when($emirates, function ($query) use ($emirates) {
                                    return $query->where('emirate_id',$emirates);
                                })
                                ->when($address, function ($query) use ($address) {
                                    return $query->where('properties.address',$address);
                                })
                                ->when($user_id, function ($query) use ($user_id, $user_type) {
                                    if($user_type == env('USER_TYPE_LANDLORD')){
                                        return  $query->where('landlord_id', $user_id);
                                    }
                                });                         
        $properties = $properties->get()
                                   ->toArray();*/
                          
        return $properties;

    }

    
    public static function instance()
    {
        return new Properties;
    }
}